package shinh;

import robocode.*;

public class Enemy extends Being {
	public String name;
	public double energy;

	public PredictPattern predictor = null;
	public PredictRevolver2 revolver;

	public double vx = 0, vy = 0;

	public boolean aimMe = false;

	public Enemy(String name) {
		this.name = name;

		//pattern = new PatternMatcher(this);
	}

	public void setScanned(ScannedRobotEvent e) {
		Entangled ent = Entangled.me;

		double energyDiff = e.getEnergy() - energy;
		if (energyDiff >= -3 && energyDiff < 0)
			ent.bmgr.addBullet(this, e, energyDiff);

		energy = e.getEnergy();
		double bearing = e.getBearingRadians();
		distance = e.getDistance();
		heading = e.getHeadingRadians();
		velocity = e.getVelocity();

		radian = Util.getRoboRadian(ent.getHeadingRadians() + bearing);
		x = distance * Math.sin(radian) + ent.getX();
		y = distance * Math.cos(radian) + ent.getY();
		turn = ent.getTime();

		predictor.pattern.addState();
	}

	public void setHit(HitRobotEvent e) {
		double bearing = e.getBearingRadians();
		distance = Const.HIT_DISTANCE;
		energy = e.getEnergy();

		Entangled ent = Entangled.me;
		radian = Util.getRoboRadian(ent.getHeadingRadians() + bearing);
		x = distance * Math.sin(radian) + ent.getX();
		y = distance * Math.cos(radian) + ent.getY();
		turn = ent.getTime();
	}

	public void setBulletHit(BulletHitEvent e) {
		energy = e.getEnergy();
	}

	public void update() {
	}

/*
	public Being getFuture(double turn) {
		return predictor.getFuture(this, turn);
	}
*/
	public double getFutureAim(double pow) {
		return predictor.getFutureAim(this, pow);
	}

}

