package shinh;

import robocode.*;

public class FireMelee extends Fire {
	private Entangled ent;

	public FireMelee() {
		ent = Entangled.me;
	}

	public void update() {
		if (ent.target != null) {
			if (ent.target.energy == 0) {
				double r = Util.getNormalRadian(
					(ent.getGunHeadingRadians() - ent.target.radian));
				ent.setTurnGunLeftRadians(r);
				ent.setFire(0.1);
				return;
			}

			if (ent.target.distance < Const.ULTRA_APPROACH_ENEMY) {
				double r = Util.getNormalRadian(
					(ent.getGunHeadingRadians() - ent.target.radian));
				ent.setTurnGunLeftRadians(r);
				ent.setFire(3);
				return;
			}

			float percent = ent.target.predictor.getPercent();

			double pow = 3;
			if (ent.getEnergy() <= 0.1) {
				double r = Util.getNormalRadian(
					(ent.getGunHeadingRadians() - ent.target.radian));
				ent.setTurnGunLeftRadians(r);
				return;
			}
			else if (ent.getEnergy() < 2) {
				pow = 0.1 * ent.getEnergy();
			}
			else if (ent.target.energy <= 16 && ent.getOthers() > 2) {
				pow = Util.getPowerFromDamage(ent.target.energy + 4);
			}
			else if (ent.getEnergy() < 30) {
				if (ent.getEnergy() > 20 &&
					percent > 20)
					pow = 3;
				else
					pow = (double)ent.getEnergy() * 0.1;
			}
			else if (percent < 30) {
				if (percent > 10) pow = percent * 0.1;
				else pow = 1;
			}

			if (ent.target.distance > 500) {
				pow *= 500 / ent.target.distance;
			}

			if (pow > 3) pow = 3;
			else if (pow < 0.1) {
				if (ent.getEnergy() > 20) pow = 0.5;
				else pow = 0.1;
			}

			double r = Util.getNormalRadian(
				(ent.getGunHeadingRadians() - ent.target.getFutureAim(pow)));
			double ar = Math.abs(r);
			ent.setTurnGunLeftRadians(r);
			if (ar < 0.1 && ent.getGunHeat() == 0 &&
				ent.target.predictor.isValid())
			{
				Bullet b = ent.setFireBullet(pow);
				if (b != null) ent.registBullet(b);
			}
		}
	}

}

