package shinh;

import robocode.*;

import java.awt.geom.Point2D;

public class Util {
	public static double getNormalRadian(double rad) {
		while (rad <= -Const.PI) rad += Const.PI2;
		while (rad > Const.PI) rad -= Const.PI2;
		return rad;
	}
	public static double getRoboRadian(double rad) {
		while (rad <= 0) rad += Const.PI2;
		while (rad > Const.PI2) rad -= Const.PI2;
		return rad;
	}
	public static double length2(double x, double y) {
		return x*x + y*y;
	}
	public static double length(double x, double y) {
		return Math.sqrt(length2(x, y));
	}
	public static double distance2(double x1, double y1,
								   double x2, double y2) {
		return length2(x1-x2, y1-y2);
	}
	public static double distance(double x1, double y1, double x2, double y2) {
		return length(x1-x2, y1-y2);
	}

	public static double calcBulletDamage(double pow) {
		return pow * 4 + ((pow > 1) ? (pow - 1) * 2 : 0);
	}

	public static int rnd(int r) {
		return (int)((double)r * Math.random());
	}

	public static double getPowerFromDamage(double damage) {
		if (damage > 4) {
			return (damage + 2) / 6;
		}
		else {
			return damage / 4;
		}
	}

}

