package tjk;
import robocode.*;
//import cs2_dev.*;
import java.util.Vector;
import java.awt.Graphics2D;
import java.util.Random;
import java.awt.Color;

/**
 * MyClass - a class by (your name here)
 */
public class VGun {
	
	private AdvancedRobot me;
	
	private static final int numberOfGuns = 26;
	
	private Vector vBullets = new Vector(9*numberOfGuns);
	
	// [gun][velocity 0-4][perpendicular 0-1][distance 0-3][wall/corner 0-2][cw/ccw 0-2][turnrate 0-2]
	private static long[][][][][][][] hits = new long[numberOfGuns][5][2][4][3][3][3];
	private static long[][][][][][][] shots = new long[numberOfGuns][5][2][4][3][3][3];
	
	private static Random rand;
	
	private double eHeading = 0;
	private double eTurnRate = 0;
	private double eTimeLastSeen = 0;
	private double enemyX = 0;
	private double enemyY = 0;
	
	public VGun(AdvancedRobot r) {
		me = r;
		rand = new Random();
	}

	public void shoot(ScannedRobotEvent e) {
		
		long time = me.getTime();
		enemyX = me.getX() + e.getDistance()*Math.sin( Math.toRadians( me.getHeading() + e.getBearing() ) );
		enemyY = me.getY() + e.getDistance()*Math.cos( Math.toRadians( me.getHeading() + e.getBearing() ) );
		double deltaT = me.getTime() - eTimeLastSeen;
		if (deltaT >= 1) {
			eTurnRate = fixAngle( (e.getHeading() - eHeading) / deltaT );
		}
		
		
		int v_segment = segmentVelocity(e.getVelocity());
		int p_segment = segmentPerpendicular(e);
		int d_segment = segmentDistance(e);
		int wall_segment = segmentWall();
		int cw_segment = segmentCW(e);
		int tr_segment = segmentTR(eTurnRate);
		
		Vector bulletsToRemove = new Vector();
		
		
		
		// Look at all bullets.	
		for ( Object o : vBullets ) {
			VBullet b = (VBullet)o;
			double x = b.getX(time);
			double y = b.getY(time);
			
			
			
			// Check for hit enemy
			if ( Math.abs(enemyX - x) <= 18 && Math.abs(enemyY - y) <= 18 ) {
				hits[b.getGun()][b.getVSeg()][b.getPSeg()][b.getDSeg()][b.getWSeg()][b.getCWSeg()][b.getTRSeg()]++;
				shots[b.getGun()][b.getVSeg()][b.getPSeg()][b.getDSeg()][b.getWSeg()][b.getCWSeg()][b.getTRSeg()]++;				
				bulletsToRemove.add(o);
				//for (int i = 0; i<numberOfGuns; i++) {
				//	System.out.println("Gun #" + i + " hit rate: " + ((double)hits[i])/((double)shots[i])*100.0 + "%");
				//}
				//System.out.println("A hit! Gun #" + b.getGun() + " hit rate: " + ((double)hits[b.getGun()])/((double)shots[b.getGun()])*100.0 + "%");
			}
		
			// Check for off battlefield
			else if ( x > me.getBattleFieldWidth() || x < 0 || y > me.getBattleFieldHeight() || y < 0 ) {
				shots[b.getGun()][b.getVSeg()][b.getPSeg()][b.getDSeg()][b.getWSeg()][b.getCWSeg()][b.getTRSeg()]++;
				bulletsToRemove.add(o);
				//System.out.println("A bullet hit the wall. Removed it.");
			}
			
			
		}
		
		//Remove dead bullets
		for (Object o : bulletsToRemove ) {
			vBullets.remove(o);
		}
		
		// Choose firepower.
		double firepower = 1.95;
		
		if ( e.getDistance() > 400 ) {
			firepower = 0.5;
		}
		else if ( e.getDistance() < 100 ) {
			firepower = 3.0;
		}
		
		if ( e.getEnergy() <= 4 ) {
			firepower = Math.min(e.getEnergy()/4+0.1,firepower);
		}
		else if ( e.getEnergy() <= 16 ) {
			firepower = Math.min(( e.getEnergy() + 2 )/6+0.1,firepower);
		}
		
		// Choose real gun.
		int gunToUse = chooseGun(firepower, v_segment, p_segment, d_segment, wall_segment, cw_segment, tr_segment);
		
		// Shoot all virtual guns.
		for (int i = 0; i < numberOfGuns; i++) {
			double shootHeading = shootHeading(i,firepower,e);
			vBullets.add( new VBullet(me.getX(),me.getY(),shootHeading,20-3*firepower,i,me.getTime(),v_segment,p_segment,d_segment,wall_segment,cw_segment,tr_segment) );
			if ( i == gunToUse ) {
				// Fire real Gun.
				me.setTurnGunLeft( fixAngle(me.getGunHeading() - shootHeading ) );
				if (me.getGunHeat() == 0) {
					me.setFire(firepower);
				}
			}
		}
	
		
		eHeading = e.getHeading();
		eTimeLastSeen = time;
	}

	private int chooseGun(double firepower, int v_segment, int p_segment, int d_segment, int wall_segment, int cw_segment, int tr_segment) {
		
		double damage = 4*firepower +  ( firepower>1 ? 2*(firepower-1) : 0 );
		double cost = firepower;
		double powerreturn = 3*firepower;
		
		double best_score = -100;
		int best_gun = -1;
		for (int k = 0; k < numberOfGuns; k++) {
			double score = ( (double)hits[k][v_segment][p_segment][d_segment][wall_segment][cw_segment][tr_segment]/(double)shots[k][v_segment][p_segment][d_segment][wall_segment][cw_segment][tr_segment] )*(powerreturn + damage - cost) - (1.0 - (double)hits[k][v_segment][p_segment][d_segment][wall_segment][cw_segment][tr_segment]/(double)shots[k][v_segment][p_segment][d_segment][wall_segment][cw_segment][tr_segment])*(cost);
			if (score > best_score) {
				best_score = score;
				best_gun = k;
			}
		}
		
		if ( best_gun != -1 && best_score > 0 ) {
			System.out.println("Best bet gun found!  Using gun " + best_gun + ", which should net me " + best_score + " points.");
			return best_gun;
		}
		else if ( rand.nextBoolean() ||  rand.nextBoolean() ) {
			System.out.println("No best gun. Bowing out for now.");
			return -1;
		}
		
		double totalshots_sq = 0.0;
		for (int i = 0; i < numberOfGuns; i++) {
			totalshots_sq += Math.pow((double)hits[i][v_segment][p_segment][d_segment][wall_segment][cw_segment][tr_segment]/(double)shots[i][v_segment][p_segment][d_segment][wall_segment][cw_segment][tr_segment],2);
		}
		
		double shotProb = rand.nextDouble();
		
		double thisshot_sq = 0.0;
		
		for ( int j = 0; j < numberOfGuns; j++ ) {
			thisshot_sq += Math.pow((double)hits[j][v_segment][p_segment][d_segment][wall_segment][cw_segment][tr_segment]/(double)shots[j][v_segment][p_segment][d_segment][wall_segment][cw_segment][tr_segment],2)/totalshots_sq;
			if (shotProb < thisshot_sq) {
				System.out.println("Choosing gun " + j + " with a hit percentage of " + (double)hits[j][v_segment][p_segment][d_segment][wall_segment][cw_segment][tr_segment]/(double)shots[j][v_segment][p_segment][d_segment][wall_segment][cw_segment][tr_segment]*100.0 );
				return j;
			}
		}
		
		return 1;
		
	}

	private double shootHeading(int gun, double firepower, ScannedRobotEvent e) {
		if ( gun == 0) {
			return dumbfire(e);
		}
		else if ( gun == 1 ) {
			return linearfire(e,firepower,1);
		}
		else if ( gun == 2 ) {
			return basiccircularfire(e,firepower);
		}
		else if ( gun == 3 ) {
			return circularfire(e, firepower, 1, 1);
		}
		else if ( gun == 4 ) {
			return circularfire(e, firepower, 0, 1);
		}
		else if ( gun == 5 ) {
			return circularfire(e, firepower, -1, 1);
		}
		else if ( gun == 6 ) {
			return circularfire(e, firepower, 1, -1);
		}
		else if ( gun == 7 ) {
			return circularfire(e, firepower, 0, -1);
		}
		else if ( gun == 8 ) {
			return circularfire(e, firepower, -1, -1);
		}
		else if ( gun == 9 ) {
			return circularfire(e, firepower, 1, 0);
		}
		else if ( gun == 10 ) {
			return circularfire(e, firepower, 0, 0);
		}
		else if ( gun == 11 ) {
			return circularfire(e, firepower, -1, 0);
		}
		else if ( gun == 12 ) {
			return perpendicularfire(e, firepower, 1, 0);
		}
		else if ( gun == 13 ) {
			return perpendicularfire(e, firepower, 0.5, 0);
		}
		else if ( gun == 14 ) {
			return perpendicularfire(e, firepower, 0, 0);
		}
		else if ( gun == 15 ) {
			return perpendicularfire(e, firepower, -0.5, 0);
		}
		else if ( gun == 16 ) {
			return perpendicularfire(e, firepower, -1, 0);
		}
		else if ( gun == 17 ) {
			return perpendicularfire(e, firepower, 1, 1);
		}
		else if ( gun == 18 ) {
			return perpendicularfire(e, firepower, 0.5, 1);
		}
		else if ( gun == 19 ) {
			return perpendicularfire(e, firepower, 0, 1);
		}
		else if ( gun == 20 ) {
			return perpendicularfire(e, firepower, -0.5, 1);
		}
		else if ( gun == 21 ) {
			return perpendicularfire(e, firepower, -1, 1);
		}
		else if ( gun == 22 ) {
			// Linear Random
			return dumbfire(e) + (2.0*rand.nextDouble()-1.0)*Math.toDegrees( Math.asin( e.getVelocity() / (20 - 3*firepower) ) );
		}
		else if ( gun == 23 ) {
			// Circular Random
			return dumbfire(e) + (2.0*rand.nextDouble()-1.0)*Math.toDegrees( e.getVelocity() / (20 - 3*firepower) );
		}
		else if ( gun == 24 ) {
			// Linear Random Gaussian Mod
			double rFactor = rand.nextGaussian()/3.0;
			return dumbfire(e) + rFactor*Math.toDegrees( Math.asin( e.getVelocity() / (20 - 3*firepower) ) );
		}
		else if ( gun == 25 ) {
			// Circular Random Gaussian Mod
			double rFactor = rand.nextGaussian()/3.0;
			return dumbfire(e) + rFactor*Math.toDegrees( e.getVelocity() / (20 - 3*firepower) );
		}
		return 0.0;
	}

	private double dumbfire(ScannedRobotEvent e) {
		return me.getHeading() + e.getBearing();
	}

	private double linearfire(ScannedRobotEvent e, double firepower, double factor) {
		return dumbfire(e) - Math.toDegrees(Math.asin( ( (factor * e.getVelocity()) / (20 - 3*firepower)) * Math.sin(Math.toRadians(180 - me.getHeading() - e.getBearing() + e.getHeading())) ));
	}

	// targetVelocity = -1,0,1  full reverse, zero, full ahead
	// targetTurnRate = -1,0,1 full ccw, zero, full cw
	private double circularfire(ScannedRobotEvent e, double firepower, double targetVelocity, double targetTurnRate) {
		double bVelocity = 20 - 3*firepower;
		double eX = enemyX;
		double eY = enemyY;
		double eH = e.getHeading();
		double v = e.getVelocity();
		targetVelocity = targetVelocity*8;
		int time = 0;
		while ( bVelocity*time < Math.sqrt( Math.pow(eX-me.getX(),2) + Math.pow(eY-me.getY(),2) ) ) {
			if ( eX<=12 || eY <= 12 || eX >= me.getBattleFieldWidth()-12 || eY >= me.getBattleFieldHeight()-12 ) {
				break;
			}
			eX += v*Math.sin( Math.toRadians( eH ) );
			eY += v*Math.cos( Math.toRadians( eH ) );
			
			if (targetVelocity > v) {
				if ( v < 0 ) {
					v += 2;
				}
				else {
					v += 1;
				}
			}
			else if (targetVelocity < v) {
				if ( v < 0 ) {
					v -= 1;
				}
				else {
					v -= 2;
				}
			}
			
			if ( Math.abs(targetVelocity - v) < 1 ) {
				v = targetVelocity;
			}
			
			eH += targetTurnRate*(10-0.75*Math.abs(v));
			time++;
		}
		return Math.toDegrees( Math.atan2( eX-me.getX() , eY-me.getY() ) );
	}

	public double basiccircularfire(ScannedRobotEvent e, double firepower) {
		double bVelocity = 20 - 3*firepower;
		double myX = me.getX();
		double myY = me.getY();
		double eX = enemyX;
		double eY = enemyY;
		double eH = e.getHeading();
		double turnRate = eTurnRate;
		int time = 0;
		while ( bVelocity*time < Math.sqrt( Math.pow(eX-myX,2) + Math.pow(eY-myY,2) ) ) {
			if ( eX<=12 || eY <= 12 || eX >= me.getBattleFieldWidth()-12 || eY >= me.getBattleFieldHeight()-12 ) {
				break;
			}
			eX += e.getVelocity()*Math.sin( Math.toRadians( eH ) );
			eY += e.getVelocity()*Math.cos( Math.toRadians( eH ) );
			eH += turnRate;
			time++;
		}
		return Math.toDegrees( Math.atan2( eX-myX , eY-myY ) );
	}

	// targetVelocity = -1,1  full reverse, full ahead
	// orbit = 0,1  no, yes
	private double perpendicularfire(ScannedRobotEvent e, double firepower, double targetVelocity, int orbit) {
		double bVelocity = 20 - 3*firepower;
		double eX = enemyX;
		double eY = enemyY;
		double meX = me.getX();
		double meY = me.getY();
		double eH = e.getHeading();
		if ( orbit == 0 ) {
			eH = quickestPerpHeading(meX, meY, eX, eY, eH);
		}
		double v = e.getVelocity();
		targetVelocity = targetVelocity*8;
		double targetHeading = quickestPerpHeading(meX, meY, eX, eY, eH);
		int time = 0;
		while ( bVelocity*time < Math.sqrt( Math.pow(eX-me.getX(),2) + Math.pow(eY-me.getY(),2) ) ) {
			if ( eX<=12 || eY <= 12 || eX >= me.getBattleFieldWidth()-12 || eY >= me.getBattleFieldHeight()-12 ) {
				break;
			}
			eX += v*Math.sin( Math.toRadians( eH ) );
			eY += v*Math.cos( Math.toRadians( eH ) );
			
			if (targetVelocity > v) {
				if ( v < 0 ) {
					v += 2;
				}
				else {
					v += 1;
				}
			}
			else if (targetVelocity < v) {
				if ( v < 0 ) {
					v -= 1;
				}
				else {
					v -= 2;
				}
			}
			
			if ( Math.abs(targetVelocity - v) < 1 ) {
				v = targetVelocity;
			}
			
			
			if ( orbit == 1) {
				
				if ( me.getVelocity() != 0.0 ) {
					meX += me.getVelocity()*Math.sin( Math.toRadians( me.getHeading() ) );
					meY += me.getVelocity()*Math.cos( Math.toRadians( me.getHeading() ) );
				}
				
				targetHeading = quickestPerpHeading(meX, meY, eX, eY, eH);
				if ( fixAngle(targetHeading-eH) > 0 ) {
					eH += (10-0.75*Math.abs(v));	
				}
				else if ( targetHeading != eH ) {
					eH -= (10-0.75*Math.abs(v));	
				}
			}
			
			
			time++;
		}
		return Math.toDegrees( Math.atan2( eX-me.getX() , eY-me.getY() ) );
	}

	private double quickestPerpHeading(double targetX, double targetY, double myX, double myY, double current_heading) {
		double h1 = Math.toDegrees(Math.atan2( targetX-myX, targetY-myY ))-90;
		if ( Math.abs(fixAngle(h1 - current_heading)) <= 90 ) {
			return h1;
		}
		else {
			return h1 + 180;
		}
	}

	public void onPaint(Graphics2D g) {
		if (vBullets.size() >= 1) {
			for (Object o : vBullets ) {
				VBullet b = (VBullet)o;
				// Set the paint color to red
				g.setColor(getColor(b.getGun()));
				// Paint a filled rectangle at where the bullets are.
				g.fillRect((int)b.getX(me.getTime())-2,(int)b.getY(me.getTime())-2, 4, 4);
			}
		}
	}

	public Color getColor(int gun) {
		if (gun <= 0) {
			return Color.red;
		}
		else if (gun == 1) {
			return Color.orange;
		}
		else if ( gun == 2 ) {
			return Color.yellow;
		}
		else if (gun == 3 || gun == 6 || gun == 9) {
			return Color.green;
		}
		else if ( gun == 4 || gun == 7 || gun == 10) {
			return Color.blue;
		}
		else if (gun == 5 || gun == 8 || gun == 11) {
			return Color.cyan;
		}
		else if ( gun == 12 || gun == 13 ) {
			return Color.magenta;
		}
		else if (gun == 14 || gun == 15) {
			return Color.pink;
		}
		else if ( gun == 16 || gun == 17 ) {
			return Color.lightGray;
		}
		return Color.white;
	}

	public int segmentVelocity(double v) {
		if ( v <= 0.01 && v >= -0.01 ) {
			return 0;
		}
		else if (v > 7.9) {
			return 1;
		}
		else if ( v < -7.9 ) {
			return 2;
		}
		else if ( v > 0 ) {
			return 3;
		}
		else {
			return 4;
		}
	}

	public int segmentPerpendicular(ScannedRobotEvent e) {
		int answer = (int)Math.abs(Math.sin( Math.toRadians( 180 - me.getHeading() - e.getBearing() + e.getHeading() ) ) );
		if ( answer != 0 && answer != 1) {
			answer = 0;
		}
		return answer;
	}

	public int segmentDistance(ScannedRobotEvent e) {
		double battleFieldDiag = Math.sqrt( Math.pow(me.getBattleFieldWidth(),2) + Math.pow(me.getBattleFieldHeight(),2) );
		int answer = (int)((e.getDistance()/battleFieldDiag)*4);
		if (answer >= 4) {
			answer = 3;
		}
		return answer;
	}

	public int segmentWall() {
		boolean closeToXWall = enemyX < 100 || enemyX > me.getBattleFieldWidth() - 100;
		boolean closeToYWall = enemyY < 100 || enemyY > me.getBattleFieldHeight() - 100;
		
		if ( closeToXWall && closeToYWall ) {
			return 0;
		}
		else if ( closeToXWall || closeToYWall ) {
			return 1;
		}
		else {
			return 2;
		}
	}

	public int segmentTR(double tr) {
		if ( Math.abs(tr) < 0.5 ) {
			return 0;
		}
		else if ( tr > 0 ) {
			return 1;
		}
		else {
			return 2;
		}
	}

	public int segmentCW(ScannedRobotEvent e) {
		double cw = e.getVelocity() * Math.sin( Math.toRadians( 180 - me.getHeading() - e.getBearing() ) );
		if ( Math.abs(cw) < 0.1 ) {
			return 0;
		}
		else if ( cw > 0.001 ) {
			return 1;
		}
		else {
			return 2;
		}
	}

	public double fixAngle(double angle) {
		angle = angle % 360;
		
		if ( angle > 180 ) {
			angle = angle - 360;
		}
		else if ( angle < -180 ) {
			angle = angle + 360;
		}
		
		return angle;
		
	}
	
}
