package nat.move;

import java.util.Arrays;

import chase.s2.stat.*;
import chase.s2.stat.BinUpdater.*;

public class MovementBuffer {
	public static final int MOVEMENT_BIN = 35;

	public static final float[] distSlicesRough = { 0f, 20f, 40f, 60f };
	public static final float[] distSlice = { 0f, 15f, 30f, 45f, 65f };
	public static final float[] distSliceFine = { 0f, 6f, 10f, 25f, 34f, 42f, 50f, 58f, 66f };

	public static final float[] velSlicesRough = { 1f, 2f, 4f, 6f };
	public static final float[] velSlices = { 1f, 1f, 3f, 5f, 7f };
	public static final float[] velSlicesFine = { 1f, 1f, 2f, 3f, 4f, 5f, 6f, 7f, 8f };

	public static final float[] latvelSlicesRough = { 2f, 2f, 4f, 6f };
	public static final float[] latvelSlices = { 2f, 1f, 3f, 5f, 7f };
	public static final float[] latvelSlicesFine = { 2f, 1f, 2f, 3f, 4f, 5f, 6f, 7f, 8f };

	public static final float[] advvelSlicesRough = { 3f, -4f, -2f, 1f };
	public static final float[] advvelSlices = { 3f, -5f, -3f, -1f, 2f };
	public static final float[] advvelSlicesFine = { 3f, -6.5f, -5f, -3.5f, -2f, -0.5f, 0.5f, 2f, 4f };

	public static final float[] acclSlices = { 4f, -0.4f, 0.4f };
	public static final float[] acclSlicesFine = { 4f, -1.2f, -0.4f, 0.5f };

	public static final float[] tsvcSlicesRough = { 5f, 0.15f, 0.357f, 0.75f };
	public static final float[] tsvcSlices = { 5f, 0.1f, 0.2f, 0.4f, 0.8f };
	public static final float[] tsvcSlicesFine = { 5f, 0.05f, 0.1f, 0.16f, 0.2f, 0.4f, 0.6f, 0.85f };

	public static final float[] tsdcSlicesRough = { 6f, 0.25f, 0.5f, 0.75f };
	public static final float[] tsdcSlices = { 6f, 0.2f, 0.4f, 0.6f, 0.8f };
	public static final float[] tsdcSlicesFine = { 6f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.8f };

	public static final float[] tssSlicesRough = { 7f, 0.1f, 0.3f, 0.5f };
	public static final float[] tssSlices = { 7f, 0.05f, 0.12f, 0.18f, 0.22f };
	public static final float[] tssSlicesFine = { 7f, 0.05f, 0.1f, 0.15f, 0.2f, 0.25f, 0.3f, 0.35f };

	public static final float[] tsdecelSlicesRough = { 8f, 0.2f, 0.4f, 0.6f };
	public static final float[] tsdecelSlices = { 8f, 0.1f, 0.3f, 0.5f, 0.7f, 0.9f };
	public static final float[] tsdecelSlicesFine = { 8f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.8f };

	public static final float[] fwallSlicesRough = { 9f, 0.33f, 0.66f };
	public static final float[] fwallSlices = { 9f, 0.25f, 0.5f, 0.75f };

	public static final float[] bwallSlicesRough = { 10f, 0.33f, 0.66f };
	public static final float[] bwallSlices = { 10f, 0.25f, 0.5f, 0.75f };

	public static final float[] dl10SlicesRough = { 11f, 7.5f, 20f, 50f };
	public static final float[] dl10Slices = { 11f, 5f, 10f, 20f, 35f, 50f, 57.5f };
	public static final float[] dl10SlicesFine = { 11f, 4f, 7.5f, 12.5f, 22.5f, 30f, 37.5f, 52.5f, 60f };

	public static final float[] dl20SlicesRough = { 12f, 7.5f, 20f, 50f };
	public static final float[] dl20Slices = { 12f, 5f, 10f, 20f, 35f, 50f, 57.5f };
	public static final float[] dl20SlicesFine = { 12f, 4f, 7.5f, 12.5f, 22.5f, 30f, 37.5f, 52.5f, 60f };

	public static final float[] dl30SlicesRough = { 13f, 7.5f, 20f, 50f };
	public static final float[] dl30Slices = { 13f, 5f, 10f, 20f, 35f, 50f, 57.5f };
	public static final float[] dl30SlicesFine = { 13f, 4f, 7.5f, 12.5f, 22.5f, 30f, 37.5f, 52.5f, 60f };

	public static StatBufferSet getPrimaryMovementBuffer() {
		return new StatBufferSet(null) {{
			add(buffer(new float[][] { }, 3f), 1);
			add(buffer(new float[][] { tsvcSlicesFine}, 0.7f), 2);
			add(buffer(new float[][] { latvelSlicesFine}, 0.7f), 2);
			add(buffer(new float[][] { fwallSlices}, 0.7f), 2);
			add(buffer(new float[][] { tsdecelSlices}, 0.7f), 2);
			add(buffer(new float[][] { acclSlicesFine}, 0.7f), 2);
			add(buffer(new float[][] { advvelSlices}, 0.7f), 3);
			add(buffer(new float[][] { bwallSlicesRough}, 0.7f), 2);
			add(buffer(new float[][] { distSlice}, 0.7f), 2);
			add(buffer(new float[][] { tsdcSlicesFine}, 0.7f), 2);
			add(buffer(new float[][] { tsvcSlicesRough, advvelSlicesFine}, 0.2f), 8);
			add(buffer(new float[][] { tsdecelSlicesFine, distSlice}, 0.2f), 8);
			add(buffer(new float[][] { acclSlicesFine, advvelSlicesRough}, 0.5f), 5);
			add(buffer(new float[][] { tsdcSlicesFine, distSlicesRough}, 0.5f), 7);
			add(buffer(new float[][] { velSlicesFine, advvelSlicesFine}, 0.2f), 16);
			add(buffer(new float[][] { latvelSlicesFine, distSliceFine}, 0.2f), 16);
			add(buffer(new float[][] { latvelSlices, bwallSlicesRough}, 0.5f), 4);
			add(buffer(new float[][] { latvelSlicesRough, velSlices}, 0.5f), 6);
			add(buffer(new float[][] { distSlice, acclSlicesFine}, 0.5f), 5);
			add(buffer(new float[][] { latvelSlicesRough, distSlicesRough}, 0.5f), 5);
			add(buffer(new float[][] { latvelSlicesRough, tsdecelSlicesRough}, 0.5f), 6);
			add(buffer(new float[][] { acclSlices, tsdcSlicesFine}, 0.5f), 5);
			add(buffer(new float[][] { tsvcSlicesRough, latvelSlicesRough}, 0.5f), 5);
			add(buffer(new float[][] { bwallSlices, acclSlicesFine}, 0.5f), 5);
			add(buffer(new float[][] { acclSlices, velSlices}, 0.5f), 4);
			add(buffer(new float[][] { latvelSlices, acclSlices, bwallSlices}, 0.2f), 17);
			add(buffer(new float[][] { latvelSlices, fwallSlices, velSlicesRough}, 0.1f), 28);
			add(buffer(new float[][] { bwallSlices, advvelSlicesRough, latvelSlicesRough}, 0.1f), 24);
			add(buffer(new float[][] { distSlicesRough, acclSlices, advvelSlicesFine}, 0.1f), 21);
			add(buffer(new float[][] { latvelSlicesRough, distSliceFine, fwallSlices}, 0.1f), 42);
			add(buffer(new float[][] { latvelSlicesRough, advvelSlicesRough, velSlicesRough}, 0.1f), 24);
			add(buffer(new float[][] { acclSlices, velSlicesFine, tsdcSlicesRough}, 0.1f), 26);
			add(buffer(new float[][] { tsdcSlicesRough, advvelSlicesRough, fwallSlicesRough}, 0.2f), 15);
			add(buffer(new float[][] { tsvcSlicesFine, acclSlicesFine, latvelSlicesRough}, 0.1f), 30);
			add(buffer(new float[][] { tssSlicesRough, acclSlicesFine, advvelSlicesRough}, 0.1f), 19);
			add(buffer(new float[][] { fwallSlices, distSlice, latvelSlicesRough}, 0.1f), 24);
			add(buffer(new float[][] { acclSlices, velSlicesRough, tssSlices}, 0.2f), 17);
			add(buffer(new float[][] { tsdcSlicesRough, acclSlicesFine, distSlicesRough}, 0.2f), 16);
			add(buffer(new float[][] { fwallSlicesRough, distSliceFine, latvelSlicesFine}, 0.1f), 45);
			add(buffer(new float[][] { velSlicesRough, acclSlices, bwallSlices}, 0.2f), 15);
			add(buffer(new float[][] { acclSlicesFine, advvelSlices, latvelSlicesFine}, 0.1f), 40);
			add(buffer(new float[][] { latvelSlicesFine, acclSlices, velSlices}, 0.1f), 30);
			add(buffer(new float[][] { dl10Slices, latvelSlicesFine, tsvcSlicesRough}, 0.1f), 47);
			add(buffer(new float[][] { tsdecelSlicesRough, distSliceFine, fwallSlicesRough}, 0.1f), 26);
			add(buffer(new float[][] { distSlicesRough, tsdecelSlicesRough, advvelSlicesRough}, 0.1f), 19);
			add(buffer(new float[][] { acclSlicesFine, tsdecelSlices, advvelSlices}, 0.1f), 27);
			add(buffer(new float[][] { acclSlices, tsdecelSlices, latvelSlices}, 0.1f), 21);
			add(buffer(new float[][] { acclSlices, advvelSlicesFine, tsvcSlices}, 0.1f), 26);
			add(buffer(new float[][] { latvelSlicesFine, tsdecelSlices, distSliceFine}, 0.1f), 89);
			add(buffer(new float[][] { bwallSlicesRough, fwallSlices, latvelSlicesRough}, 0.2f), 15);
			add(buffer(new float[][] { bwallSlicesRough, tsdcSlicesRough, latvelSlicesRough, acclSlices}, 0.1f), 42);
			add(buffer(new float[][] { tsdcSlicesFine, fwallSlices, acclSlices, advvelSlices}, 0.1f), 132);
			add(buffer(new float[][] { fwallSlicesRough, distSlice, acclSlices, tsvcSlicesFine}, 0.1f), 66);
			add(buffer(new float[][] { bwallSlicesRough, distSliceFine, tsvcSlicesFine, fwallSlicesRough}, 0.1f), 119);
			add(buffer(new float[][] { latvelSlicesFine, velSlicesRough, acclSlicesFine, tsvcSlicesFine}, 0.1f), 263);
			add(buffer(new float[][] { fwallSlicesRough, tsvcSlicesFine, acclSlices, velSlices}, 0.1f), 80);
			add(buffer(new float[][] { tsdcSlicesRough, bwallSlicesRough, distSlice, fwallSlicesRough}, 0.1f), 42);
			add(buffer(new float[][] { distSliceFine, acclSlices, latvelSlicesFine, tsdcSlices}, 0.1f), 266);
			add(buffer(new float[][] { fwallSlicesRough, tsdecelSlicesRough, distSliceFine, acclSlices}, 0.1f), 75);
			add(buffer(new float[][] { tsdecelSlicesFine, dl10Slices, fwallSlices, distSliceFine}, 0.1f), 459);
			add(buffer(new float[][] { acclSlices, latvelSlicesFine, advvelSlices, tsdecelSlices}, 0.1f), 178);
			add(buffer(new float[][] { acclSlices, latvelSlices, bwallSlices, tsdecelSlices}, 0.1f), 99);
			add(buffer(new float[][] { acclSlices, latvelSlices, distSliceFine, tsdcSlicesRough}, 0.1f), 148);
			add(buffer(new float[][] { acclSlices, velSlicesFine, distSlice, tsvcSlicesFine}, 0.1f), 197);
			add(buffer(new float[][] { latvelSlicesFine, dl10SlicesRough, tsvcSlicesRough, distSliceFine}, 0.1f), 237);
			add(buffer(new float[][] { velSlicesFine, latvelSlicesFine, advvelSlicesRough, dl30Slices}, 0.1f), 516);
			add(buffer(new float[][] { fwallSlices, latvelSlicesFine, dl30Slices, acclSlices}, 0.1f), 173);
			add(buffer(new float[][] { acclSlicesFine, bwallSlices, tsvcSlices, velSlicesRough}, 0.1f), 92);
			add(buffer(new float[][] { tsdecelSlicesFine, distSlicesRough, fwallSlices, advvelSlicesRough}, 0.1f), 146);
			add(buffer(new float[][] { advvelSlices, velSlices, dl20SlicesFine, distSliceFine}, 0.1f), 531);
			add(buffer(new float[][] { distSlice, advvelSlicesRough, latvelSlicesRough, tsvcSlicesFine}, 0.1f), 183);
			add(buffer(new float[][] { acclSlices, fwallSlicesRough, distSlice, latvelSlicesFine}, 0.1f), 75);
			add(buffer(new float[][] { acclSlicesFine, distSlicesRough, dl30SlicesFine, dl10SlicesFine}, 0.1f), 237);
			add(buffer(new float[][] { advvelSlicesRough, acclSlicesFine, tsvcSlices, latvelSlices}, 0.1f), 110);
			add(buffer(new float[][] { velSlicesFine, acclSlicesFine, dl30SlicesRough, tsdcSlicesRough}, 0.1f), 132);
			add(buffer(new float[][] { tssSlices, latvelSlicesFine, distSlice, advvelSlicesRough}, 0.1f), 246);
			add(buffer(new float[][] { acclSlicesFine, tsdecelSlicesFine, distSlice, fwallSlicesRough}, 0.1f), 88);
			add(buffer(new float[][] { dl30SlicesRough, tsdcSlicesFine, acclSlices, bwallSlicesRough}, 0.1f), 53);
			add(buffer(new float[][] { distSlicesRough, acclSlices, dl10Slices, latvelSlices}, 0.1f), 93);
			add(buffer(new float[][] { latvelSlicesRough, acclSlices, advvelSlicesRough, dl20SlicesRough}, 0.1f), 56);
			add(buffer(new float[][] { distSlice, latvelSlices, acclSlices, advvelSlicesFine}, 0.1f), 148);
			add(buffer(new float[][] { acclSlicesFine, velSlices, distSlicesRough, dl10SlicesFine}, 0.1f), 158);
			add(buffer(new float[][] { acclSlicesFine, latvelSlices, dl20SlicesRough, distSlicesRough}, 0.1f), 71);
			add(buffer(new float[][] { latvelSlices, velSlicesRough, tssSlicesRough, fwallSlicesRough}, 0.1f), 83);
			add(buffer(new float[][] { distSlice, latvelSlicesFine, bwallSlices, acclSlices}, 0.1f), 124);
			add(buffer(new float[][] { acclSlicesFine, tsdcSlicesRough, latvelSlices, dl30Slices}, 0.1f), 154);
			add(buffer(new float[][] { bwallSlices, acclSlicesFine, latvelSlicesFine, dl10Slices}, 0.1f), 230);
			add(buffer(new float[][] { latvelSlices, distSliceFine, bwallSlices, fwallSlices}, 0.1f), 246);
			add(buffer(new float[][] { velSlicesFine, fwallSlices, bwallSlices, latvelSlicesRough}, 0.1f), 206);
			add(buffer(new float[][] { fwallSlices, latvelSlicesFine, bwallSlicesRough, velSlices}, 0.1f), 148);
			add(buffer(new float[][] { advvelSlicesRough, latvelSlicesRough, velSlicesFine, acclSlicesFine}, 0.1f), 165);
			add(buffer(new float[][] { acclSlices, latvelSlicesFine, advvelSlices, bwallSlicesRough}, 0.1f), 89);
			add(buffer(new float[][] { latvelSlicesFine, acclSlicesFine, velSlicesFine, tsdecelSlices}, 0.1f), 354);
			add(buffer(new float[][] { acclSlices, velSlicesFine, dl20SlicesFine, distSlicesRough}, 0.1f), 178);
			add(buffer(new float[][] { latvelSlicesRough, acclSlicesFine, advvelSlicesFine, velSlicesRough}, 0.1f), 165);
			add(buffer(new float[][] { latvelSlicesFine, fwallSlices, tssSlices, acclSlices}, 0.1f), 148);
			add(buffer(new float[][] { latvelSlices, tsdcSlicesFine, tssSlicesFine, acclSlicesFine}, 0.1f), 280);
			add(buffer(new float[][] { acclSlicesFine, tsdecelSlicesRough, latvelSlicesRough, distSlice}, 0.1f), 92);
			add(buffer(new float[][] { distSlice, tsdcSlicesRough, velSlices, bwallSlices}, 0.1f), 137);
			add(buffer(new float[][] { acclSlices, distSlice, latvelSlicesRough, tsdecelSlicesRough}, 0.1f), 69);
			add(buffer(new float[][] { bwallSlicesRough, advvelSlicesRough, velSlicesRough, tssSlicesFine}, 0.1f), 110);
			add(buffer(new float[][] { distSliceFine, tsdcSlicesFine, velSlicesRough, latvelSlicesRough}, 0.1f), 328);
			add(buffer(new float[][] { velSlicesFine, fwallSlices, tsdcSlicesRough, acclSlices}, 0.1f), 124);
			add(buffer(new float[][] { acclSlicesFine, distSlice, velSlicesFine, latvelSlices}, 0.1f), 197);
			add(buffer(new float[][] { advvelSlicesFine, latvelSlicesRough, distSlice, tsdecelSlicesRough}, 0.1f), 206);
			add(buffer(new float[][] { velSlicesRough, advvelSlices, bwallSlices, distSlicesRough}, 0.1f), 110);
			add(buffer(new float[][] { dl30Slices, velSlices, latvelSlicesRough, distSlicesRough}, 0.1f), 154);
			add(buffer(new float[][] { velSlicesFine, acclSlicesFine, latvelSlicesFine, distSliceFine}, 0.1f), 531);
			add(buffer(new float[][] { acclSlicesFine, dl10SlicesFine, velSlicesRough, tsvcSlicesRough}, 0.1f), 132);
			add(buffer(new float[][] { distSlice, latvelSlicesRough, advvelSlicesFine, velSlicesFine}, 0.1f), 369);
		}};
	}
	
	public static StatBufferSet getSecondaryMovementBuffer() {
		return new StatBufferSet(null) {{
			add(buffer(new float[][] { }, 3f*100f), 1);
			add(buffer(new float[][] { distSlice}, 0.7f*100f), 2);
			add(buffer(new float[][] { latvelSlices}, 0.7f*100f), 2);
			add(buffer(new float[][] { fwallSlicesRough}, 0.7f*100f), 2);
			add(buffer(new float[][] { acclSlicesFine}, 0.7f*100f), 2);
			add(buffer(new float[][] { dl20SlicesRough, advvelSlices}, 0.5f*100f), 5);
			add(buffer(new float[][] { fwallSlices, bwallSlices}, 0.5f*100f), 6);
			add(buffer(new float[][] { latvelSlicesFine, distSlicesRough}, 0.5f*100f), 5);
			add(buffer(new float[][] { tsvcSlicesRough, distSliceFine}, 0.2f*100f), 8);
			add(buffer(new float[][] { velSlicesFine, acclSlices}, 0.5f*100f), 6);
			add(buffer(new float[][] { latvelSlicesRough, velSlicesFine, bwallSlicesRough}, 0.1f*100f), 26);
			add(buffer(new float[][] { velSlicesRough, dl10SlicesRough, acclSlices}, 0.2f*100f), 12);
			add(buffer(new float[][] { fwallSlices, bwallSlices, tsdecelSlicesFine}, 0.1f*100f), 37);
			add(buffer(new float[][] { acclSlicesFine, bwallSlicesRough, dl30Slices}, 0.2f*100f), 16);
			add(buffer(new float[][] { fwallSlicesRough, acclSlicesFine, bwallSlices}, 0.2f*100f), 12);
			add(buffer(new float[][] { tssSlices, latvelSlices, advvelSlicesFine}, 0.1f*100f), 60);
			add(buffer(new float[][] { acclSlices, velSlicesFine, tsdecelSlicesFine}, 0.1f*100f), 40);
			add(buffer(new float[][] { bwallSlices, dl20SlicesFine, tsvcSlices}, 0.1f*100f), 42);
			add(buffer(new float[][] { latvelSlicesRough, acclSlicesFine, advvelSlices}, 0.1f*100f), 23);
			add(buffer(new float[][] { acclSlices, fwallSlices, advvelSlices}, 0.2f*100f), 17);
			add(buffer(new float[][] { latvelSlicesRough, distSlice, velSlices}, 0.1f*100f), 28);
			add(buffer(new float[][] { distSlice, tssSlices, latvelSlicesFine}, 0.1f*100f), 50);
			add(buffer(new float[][] { tssSlicesRough, velSlices, tsdecelSlicesRough}, 0.1f*100f), 28);
			add(buffer(new float[][] { latvelSlicesRough, fwallSlicesRough, acclSlicesFine}, 0.2f*100f), 12);
			add(buffer(new float[][] { latvelSlicesFine, velSlicesFine, fwallSlicesRough}, 0.1f*100f), 45);
			add(buffer(new float[][] { velSlicesRough, acclSlices, tsdcSlices, fwallSlicesRough}, 0.1f*100f), 50);
			add(buffer(new float[][] { latvelSlicesFine, distSliceFine, acclSlices, velSlices}, 0.1f*100f), 266);
			add(buffer(new float[][] { acclSlices, velSlicesFine, bwallSlicesRough, latvelSlicesFine}, 0.1f*100f), 134);
			add(buffer(new float[][] { acclSlicesFine, distSliceFine, advvelSlicesRough, fwallSlicesRough}, 0.1f*100f), 99);
			add(buffer(new float[][] { bwallSlices, acclSlices, tsdecelSlicesFine, distSliceFine}, 0.1f*100f), 197);
			add(buffer(new float[][] { velSlicesRough, latvelSlices, bwallSlicesRough, distSlice}, 0.1f*100f), 83);
			add(buffer(new float[][] { latvelSlicesFine, acclSlicesFine, bwallSlicesRough, tsvcSlicesFine}, 0.1f*100f), 158);
			add(buffer(new float[][] { tsvcSlices, acclSlicesFine, latvelSlicesRough, tssSlicesFine}, 0.1f*100f), 146);
			add(buffer(new float[][] { acclSlicesFine, advvelSlicesRough, distSlice, tssSlicesFine}, 0.1f*100f), 146);
			add(buffer(new float[][] { latvelSlicesRough, velSlices, distSlice, advvelSlicesFine}, 0.1f*100f), 246);
			add(buffer(new float[][] { latvelSlicesRough, acclSlices, velSlicesFine, fwallSlicesRough}, 0.1f*100f), 75);
			add(buffer(new float[][] { latvelSlicesRough, acclSlicesFine, fwallSlices, bwallSlicesRough}, 0.1f*100f), 56);
			add(buffer(new float[][] { velSlicesRough, latvelSlicesFine, acclSlices, bwallSlices}, 0.1f*100f), 124);
			add(buffer(new float[][] { distSliceFine, acclSlices, velSlicesRough, fwallSlicesRough}, 0.1f*100f), 75);
			add(buffer(new float[][] { latvelSlicesRough, fwallSlices, tsdecelSlicesRough, distSlice}, 0.1f*100f), 115);
			add(buffer(new float[][] { latvelSlices, acclSlices, tssSlices, advvelSlicesFine}, 0.1f*100f), 178);
			add(buffer(new float[][] { velSlicesRough, bwallSlicesRough, latvelSlicesRough, tsdecelSlicesFine}, 0.1f*100f), 110);
			add(buffer(new float[][] { bwallSlicesRough, fwallSlicesRough, acclSlices, latvelSlicesFine}, 0.1f*100f), 45);
			add(buffer(new float[][] { tsdecelSlicesRough, distSlicesRough, advvelSlices, acclSlices}, 0.1f*100f), 66);
			add(buffer(new float[][] { tssSlices, latvelSlicesFine, tsvcSlicesFine, acclSlicesFine}, 0.1f*100f), 315);
			add(buffer(new float[][] { velSlicesRough, tsvcSlices, fwallSlices, latvelSlicesFine}, 0.1f*100f), 206);
			add(buffer(new float[][] { dl30Slices, fwallSlices, dl10SlicesFine, acclSlices}, 0.1f*100f), 173);
			add(buffer(new float[][] { acclSlices, latvelSlicesRough, advvelSlices, distSlice}, 0.1f*100f), 83);
			add(buffer(new float[][] { advvelSlices, fwallSlices, dl20SlicesRough, acclSlices}, 0.1f*100f), 66);
			add(buffer(new float[][] { acclSlicesFine, latvelSlicesRough, tssSlicesFine, distSlicesRough}, 0.1f*100f), 117);
			add(buffer(new float[][] { dl30SlicesRough, acclSlicesFine, distSliceFine, advvelSlicesRough}, 0.1f*100f), 132);
			add(buffer(new float[][] { velSlicesRough, tsdecelSlicesFine, latvelSlicesFine, dl30SlicesRough}, 0.1f*100f), 263);
			add(buffer(new float[][] { latvelSlices, bwallSlices, velSlicesFine, tssSlicesFine}, 0.1f*100f), 394);
			add(buffer(new float[][] { latvelSlicesFine, fwallSlicesRough, velSlicesFine, advvelSlicesFine}, 0.1f*100f), 399);
			add(buffer(new float[][] { distSliceFine, latvelSlicesFine, acclSlices, bwallSlicesRough}, 0.1f*100f), 134);
		}};
	}

	private static StatBuffer buffer(float[][] data, float rollingWeight) {
		SplitSet ss = new SplitSet();
		for (float[] d : data) {
			ss.add(Arrays.copyOfRange(d, 1, d.length), (int) Math.round(d[0]));
		}
		return new StatBuffer(ss, MOVEMENT_BIN, new RollingAverageUpdater(
				new DefaultUpdater(), rollingWeight));
	}
}
