package djc;
import robocode.*;

/**
 * DisabledTacticalStrategy
 *
 * Placeholder for becoming disabled...
 *
 * All code created by Dan Cieslak, 2002.
 *
 * All code that is mine is available for anyone to use for
 * any purpose, so long as I am listed as a source.
 *
 */
public class DisabledTacticalStrategy extends DefaultTacticalStrategy
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    public DisabledTacticalStrategy (StrategyBot theRobot, TacticalStrategyManager theStrategyManager)
    {
	super(theRobot, theStrategyManager);
	name = TacticalStrategyManager.DISABLED;
    }

    /**
     * reset - Initialize the strategy
     */
    public void startTurn()
    {
	if(self.getEnergy() > 0) {
	    //self.strategyManager.setInitialStrategy();
	    //self.strategyManager.decideStrategyChange();
	    if(self.getOthers() > 2) {
		self.strategyManager.setStrategy(self.strategyManager.CORNERS);
	    } else {
		self.strategyManager.setStrategy(self.strategyManager.INITIAL);
	    }
	    self.strategyManager.decideStrategyChange();
	}
    }

    /**
     * reset - Initialize the strategy
     */
    public void reset()
    {
	self.setAdjustGunForRobotTurn(true);
    }

    /**
     * Stop (cannot go anywhere anyway)
     */
    public void setMovement()
    {

    }

}
