package djc;
import robocode.*;

/**
 * VictoryTacticalStrategy
 *
 * Head to lower left corner, for now.
 *
 * All code created by Dan Cieslak, 2002.
 *
 * All code that is mine is available for anyone to use for
 * any purpose, so long as I am listed as a source.
 *
 */
public class VictoryTacticalStrategy extends DefaultTacticalStrategy
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */
    public VictoryTacticalStrategy (StrategyBot theRobot, TacticalStrategyManager theStrategyManager)
    {
	super(theRobot, theStrategyManager);
	name = TacticalStrategyManager.VICTORY;
    }

    /**
     * reset - Initialize the strategy
     */
    public void startTurn()
    {
	if(self.getOthers() > 0) {
	    //self.strategyManager.setInitialStrategy();
	    //self.strategyManager.decideStrategyChange();
	    if(self.getOthers() > 2) {
		self.strategyManager.setStrategy(self.strategyManager.CORNERS);
	    } else {
		self.strategyManager.setStrategy(self.strategyManager.INITIAL);
	    }
	    self.out.println("Current strat changed from VICTORY to " + self.currentStrategy.name);
	}
    }

    /**
     * reset - Initialize the strategy
     */
    public void reset()
    {
	self.setAdjustGunForRobotTurn(true);
    }

    /**
     * Nothing
     */
    public void setScan() {   }

    /**
     * Nothing
     */
    public void setGunRotation() {   }

    /**
     * Stop (for now).
     */
    public void setMovement()
    {

    }

}
