package staticline;

import java.awt.Graphics2D;

import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import staticline.whiskey.fc.FireControlManager;
import staticline.whiskey.intel.IntelligenceManager;
import staticline.whiskey.movement.WaveSurfing;
import staticline.whiskey.radar.RadarManager;
import staticline.whiskey.targeting.TargetingManager;
import staticline.whiskey.utils.PaintManager;


public abstract class AbstractAdvancedRobot extends AdvancedRobot {
	protected final IntelligenceManager intelligence;
	protected final WaveSurfing movement;
	protected final TargetingManager targeting;
	protected final RadarManager radar;
	protected final FireControlManager firecontrol;
	protected final PaintManager paint;
	
	public AbstractAdvancedRobot() {
		this.intelligence = new IntelligenceManager(this);
		this.movement = new WaveSurfing(this);
		this.targeting = new TargetingManager(this);
		this.radar = new RadarManager(this);
		this.firecontrol = new FireControlManager(this);
		this.paint = new PaintManager(this);
	}
	
	@Override
	public void run(){
		//systems
		this.intelligence.initialize();
		this.movement.initialize();
		this.targeting.initialize();
		this.firecontrol.initialize();
		//utils
		this.paint.initialize();
		//loops
		while(true){
			this.radar.initialize();
		}
	}
	
	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		this.intelligence.onScannedRobot(e);
		this.movement.onScannedRobot(e);
		this.targeting.onScannedRobot(e);
		this.firecontrol.onScannedRobot(e);
		this.radar.onScannedRobot(e);
		//utils
		this.paint.onScannedRobot(e);
	}
	
	@Override
	public void onHitByBullet(HitByBulletEvent e){
		this.movement.onHitByBullet(e);
	}
	
	@Override
	public void onHitWall(HitWallEvent e){
		this.movement.onHitWall(e);
	}
	
	@Override
	public void onPaint(Graphics2D g) {
		this.paint.onPaint(g);
	}
}
