package simonton.core;

import java.awt.*;

import robocode.*;
import simonton.utils.*;

public class SlaveBot implements Bot {
	private String name;
	private Bullet bullet;
	private double gunTurnRemainingRadians;
	private double turnRemainingRadians;
	private double distanceRemaining;
	private double gunHeadingRadians;
	private double headingRadians;
	private double velocity;
	private double gunHeat;
	private double energy;
	private double x;
	private double y;
	private long time;
	private int roundNum;
	private int numRounds;

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#run()
	 */
	public void run() {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#onScannedRobot(robocode.ScannedRobotEvent)
	 */
	public void onScannedRobot(ScannedRobotEvent e) {

	}

	public void onBulletHit(BulletHitEvent e) {

	}

	public void onBulletMissed(BulletMissedEvent e) {

	}

	public void onHitByBullet(HitByBulletEvent e) {

	}

	public void onHitRobot(HitRobotEvent e) {

	}

	public void onHitWall(HitWallEvent e) {

	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {
		
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#onDeath(robocode.DeathEvent)
	 */
	public void onDeath(DeathEvent e) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#onWin(robocode.WinEvent)
	 */
	public void onWin(WinEvent e) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#onPaint(java.awt.Graphics2D)
	 */
	public void onPaint(Graphics2D g) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getGunCoolingRate()
	 */
	public double getGunCoolingRate() {
		return Util.gunCoolingRate;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#setTurnRightRadians(double)
	 */
	public void setTurnRightRadians(double toTurn) {
		turnRemainingRadians = toTurn;
	}
	
	/* (non-Javadoc)
	 * @see simonton.core.Bot#setTurnRight(double)
	 */
	public void setTurnRight(double toTurn) {
		turnRemainingRadians = Math.toRadians(toTurn);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#setTurnGunRightRadians(double)
	 */
	public void setTurnGunRightRadians(double toTurn) {
		gunTurnRemainingRadians = toTurn;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#setAhead(double)
	 */
	public void setAhead(double toMove) {
		distanceRemaining = toMove;
	}
	
	/* (non-Javadoc)
	 * @see simonton.core.Bot#setBack(double)
	 */
	public void setBack(double toMove) {
		distanceRemaining = -toMove;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getDistanceRemaining()
	 */
	public double getDistanceRemaining() {
		return distanceRemaining;
	}

	public void setDistanceRemaining(double distanceRemaining) {
		this.distanceRemaining = distanceRemaining;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getHeadingRadians()
	 */
	public double getHeadingRadians() {
		return headingRadians;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getHeading()
	 */
	public double getHeading() {
		return Math.toDegrees(headingRadians);
	}

	public void setHeadingRadians(double headingRadians) {
		this.headingRadians = headingRadians;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getTurnRemainingRadians()
	 */
	public double getTurnRemainingRadians() {
		return turnRemainingRadians;
	}

	public void setTurnRemainingRadians(double turnRemainingRadians) {
		this.turnRemainingRadians = turnRemainingRadians;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getVelocity()
	 */
	public double getVelocity() {
		return velocity;
	}

	public void setVelocity(double velocity) {
		this.velocity = velocity;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getX()
	 */
	public double getX() {
		return x;
	}

	public void setX(double x) {
		this.x = x;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getY()
	 */
	public double getY() {
		return y;
	}

	public void setY(double y) {
		this.y = y;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getTime()
	 */
	public long getTime() {
		return time;
	}

	public void setTime(long time) {
		this.time = time;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getGunHeadingRadians()
	 */
	public double getGunHeadingRadians() {
		return gunHeadingRadians;
	}

	public void setGunHeadingRadians(double gunHeadingRadians) {
		this.gunHeadingRadians = gunHeadingRadians;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getGunTurnRemainingRadians()
	 */
	public double getGunTurnRemainingRadians() {
		return gunTurnRemainingRadians;
	}

	public void setGunTurnRemainingRadians(double gunTurnRemainingRadians) {
		this.gunTurnRemainingRadians = gunTurnRemainingRadians;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getGunHeat()
	 */
	public double getGunHeat() {
		return gunHeat;
	}

	public void setGunHeat(double gunHeat) {
		this.gunHeat = gunHeat;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getEnergy()
	 */
	public double getEnergy() {
		return energy;
	}

	public void setEnergy(double energy) {
		this.energy = energy;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getNumRounds()
	 */
	public int getNumRounds() {
		return numRounds;
	}

	public void setNumRounds(int numRounds) {
		this.numRounds = numRounds;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#getRoundNum()
	 */
	public int getRoundNum() {
		return roundNum;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#setRoundNum(int)
	 */
	public void setRoundNum(int roundNum) {
		this.roundNum = roundNum;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see simonton.core.Bot#setFireBullet(double)
	 */
	public Bullet setFireBullet(double power) {
		return bullet;
	}

	public void setBullet(Bullet bullet) {
		this.bullet = bullet;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}
