package franzor.guns;

import robocode.*;
import franzor.*;
import java.awt.geom.Point2D;

/**
 * MyClass - a class by (your name here)
 */
public class LinearGun implements Gun {
	
	public LinearGun() { }
	
	public Point2D getGunTarget(Info info, StatPack stats, AdvancedRobot lizt, double vbullet) {
		if(info == null) return null;
		
		double a, b, c, t1;
		double x, y, vx, vy, vb;
		
		x = lizt.getX() - info.location().getX();
		y = lizt.getY() - info.location().getY();
		vx = info.velocity().getXComp();
		vy = info.velocity().getYComp();
		vb = vbullet;
		
		a = vx*vx + vy*vy - vb*vb;
		b = (-2)*(x*vx + y*vy);
		c = x*x + y*y;
		
		t1 = ((-1)*b - Math.sqrt(b*b-4*a*c))/(2*a);
		
		return locAtTime(t1, info);
	}
	
	private Point2D locAtTime(double t, Info info) {
		double x = info.location().getX() + info.velocity().getXComp()*t;
		double y = info.location().getY() + info.velocity().getYComp()*t;
		
		return new Point2D.Double(x, y);
	}
}
