package tzu;
import robocode.*;
import java.awt.*;
import tzu.util.*;
import tzu.movement.*;

/**
 * Provides an abstract advanced robot with many useful features.<p>
 * Copyright:   Copyright (c) 2001-2002.<br>
 * Company:     Rideau Code Works Inc.<br>
 *
 * You are given permission to copy and modify any code in the tzu package
 * provided:
 * <ul>
 *      <li> you distribute your robot as open source and...</li>
 *      <li> you identify which parts have been copied and...</li>
 *      <li> you include similar requirements with your source and...</li>
 *      <li> if you copy the majority of the code and only make small
 *           changes (effectively producing a variant) you indicate
 *           it as such by keeping the package name the same and...</li>
 *      <li> send me an email!  I like to hear from other
 *           robocode enthusiasts!</li>
 * </ul>
 *
 * @author      Ray Vermette
 * @version     0.1
 */
public class TheArtOfWar extends AbstractAdvancedRobot {

    static VictoryDance victoryDance;

    /**
     * Do the default battle initialization stuff and set our colors.
     */
    public void initializeBattle() {
        super.initializeBattle();
        setColors(Color.black, Color.red, Color.white);
        victoryDance = new VictoryDance(this);
    }

    public void onRobotDeath(RobotDeathEvent e) {

        enemyManager.onRobotDeath(e);
        if (getOthers() < 1) {
            victoryDance.mockTheEnemy();
        }
    }
}
