package tzu.movement;
import tzu.util.*;
import tzu.intel.*;
import robocode.*;
import java.util.*;

/**
 * Dance a little jig.
 */
public class VictoryDance implements Constants {

    static final String[] quotes = {
        "All warefare is based on deception.",
        "...when able to attack, we must seem unable.",
        "Hold out baits to entice the enemy.  Feign disorder, and crush him.",
        "Pretend to be weak, so that (the enemy) may grow arrogant.",
        "Attack (the enemy) where he is unprepared, appear where you are " +
        "not expected.",
        "The general who loses a battle makes but a few calculations " +
        "beforehand.",
        "In war, then, let your great object be victory, not lengthy " +
        "campaigns.",
        "If you know the enemy and know yourself, you need not fear the " +
        "result of a hundred battles.",
        "The general who is skilled in defense hides in the most secret " +
        "recesses of the earth.",
        "Indirect tatics, efficiently applied, are inexhaustible as Heaven " +
        "and Earth....",
        "By discovering the enemy's dispositions and remaining invisible " +
        "ourselves, we can keep our forces concentrated, while the enemy's " +
        "must be divided.",
        "Force (the enemy) to reveal himself, so as to find out his " +
        "vulnerable spots.",
        "Do not repeat the tatics which have gained you one victory, but " +
        "let your methods be regulated by the infinite variety of " +
        "circumstances.",
        "So in war, the way is to avoid what is strong and to strike " +
        "at what is weak.",
        "...just as water retains no constant shape, so in warefare there " +
        "are no constant conditions.",
        "The difficulty of tactical maneuvering consists in turning the " +
        "devious into the direct, and misfortune into gain.",
        "In war, practice dissimulation, and you will succeed.",
        "Let your plans be dark and inpenetrable as night, and when you " +
        "move, fall like a thunderbolt.",
        "Ponder and deliberate before you make a move.",
        "It is a military axiom not to advance uphill against the enemy, " +
        "nor to oppose him when he comes downhill.",
        "Do not swallow bait offered by the enemy.",
        "Do not press a desperate foe too hard.",
        "The rising of birds in their flight is the sign of ambush.",
        "Peace proposals unaccompanied by a sworn covenant indicate a plot.",
        "He who exercises no forethought but makes light of his opponent " +
        "is sure to be captured by them.",
        "If you are situated at a great distance from the enemy, and the " +
        "strength of the two armies is equal, it is not easy to provoke a " +
        "battle, and fighting will be to your disadvantage.",
        "If you know the enemy and you know yourself, your victory will not " +
        "stand in doubt; if you know Heaven and know Earth, you may make " +
        "your victory complete.",
        "Those who were called skillful leaders of old knew how to drive " +
        "a wedge between the enemy's front and rear....",
        "Soldiers when in desperate straits lose the sense of fear.",
        "The skillful tactician may be likened to the shuai-jan.",
        "It is the business of a general to be quiet and thus ensure secrecy.",
        "Hence those who use fire as an aid to the attack show intelligence.",
        "The enlightened ruler lays his plans well ahead;",
        "Move not unless you see an advantage;",
        "If it is to your advantage, make a forward move; if not, stay " +
        "where you are.",
        "...to remain in ignorance of the enemy's condition simply because " +
        "one grudges the outlay of a hundred ounces of silver in honors and" +
        "emoluments, is the height of inhumanity.",
        "When these five kinds of spy are all at work, none can discover" +
        "the secret system.  This is called 'divine manipulation of the " +
        "threads'.  It is the sovereign's most precious faculty"
    };

    static Random random;
    static AdvancedRobot r;

    public VictoryDance(AdvancedRobot myRobot) {

        random = new Random();
        r = myRobot;

    }

    public void mockTheEnemy() {

        r.out.println(quotes[random.nextInt(quotes.length - 1)]);

        if (BattleField.getMaxX() - r.getX() > 200 &&
            BattleField.getMaxY() - r.getY() > 200) {

            r.stop();
            r.turnRight(BotMath.plusMinus180(r.getHeading(), 0));
            r.ahead(200);
            r.turnRight(90);
            r.setTurnRight(180);
            r.setMaxVelocity(6);
            r.ahead(150);
            r.turnRight(45);
            r.back(100);
            while (true) r.execute();

        }

        while (true) {
            r.setTurnRadarRight(360);
            r.setTurnGunLeft(360);
            r.setTurnRight(360);
            r.setMaxVelocity(2);
            r.setAhead(10);
            r.execute();
        }
    }
}


