package nat.gun.meteorite;

import java.util.ArrayList;
import java.util.Collection;

import robocode.RobotStatus;
import robocode.ScannedRobotEvent;

import nat.utils.M;
import nat.utils.Point;
import nat.wave.Wave;

public final class Enemy {
	public String name;
	public boolean isAlive;
	public PIFViewsSet viewsSet;
	public ArrayList<Wave> gunWaves;
	public Trace first, last;
	public ScanInfo lastScanInfo;
	
	private Wave lastWave;

	public Enemy(String name) {
		this.name = name;
		isAlive = true;
		viewsSet = new PIFViewsSet();
	}

	public final void kill() {
		isAlive = false;
	}

	public void newRound() {
		gunWaves.clear();
		isAlive = true;
		lastScanInfo = null;
	}

	public final void update() {
		
	}
	
	public final void updateWave(Trace before, Trace last) {
		// update wave status
		while (before != last) {
			before = before.next;
			for (Wave wave : gunWaves) {
				wave.update(before);
			}
		}
		
		// update views weighting
		for (int i = 0; i < gunWaves.size(); i++) {
			Wave wave = gunWaves.get(i);
			if (wave.status == Wave.PASSED) {
				gunWaves.remove(i--);
				viewsSet.adjustWeight(wave);
			}
		}
	}
	
	// ///////////////////////////////////
	// Wave API Call
	public final void fire(Point fireLocation, double power, long time) {
		lastWave = new Wave(fireLocation, fireLocation.angle(lastScanInfo), lastScanInfo.direction, power, time);
	}
	
	public final void postFire(Point fireLocation, long time) {
		lastWave.fireTime = time;
		lastWave.fireLocation = fireLocation;
		gunWaves.add(lastWave);
		lastWave = null;
	}
	// End Wave API Call
	// ////////////////////////////////////

	// ///////////////////////////////////
	// ScanInfo
	public void calculateBasicScanInfo(RobotStatus status, ScannedRobotEvent e) {
		Point myLocation = new Point(status.getX(), status.getY());
		ScanInfo scan = new ScanInfo(M.project(myLocation, e
				.getBearingRadians()
				+ status.getHeadingRadians(), e.getDistance()));
		scan.heading = e.getHeadingRadians();
		scan.velocity = e.getVelocity();
		scan.absBearing = e.getBearingRadians() + status.getHeadingRadians();
		scan.lateralVelocity = scan.velocity
				* M.sin(scan.heading - scan.absBearing);
		scan.advancingVelocity = scan.velocity
				* -M.cos(scan.heading - scan.absBearing);
		scan.direction = (M.abs(scan.velocity) < 0.01 && lastScanInfo != null) ? lastScanInfo.direction
				: (int) M.sign(scan.lateralVelocity);
		scan.accerelation = lastScanInfo == null ? M.limit(-M.DECELERATION,
				scan.velocity, M.ACCELERATION) : lastScanInfo.velocity
				- scan.velocity;
		scan.distance = e.getDistance();
		scan.wallDistanceForward = 1;
		scan.wallDistanceBackward = -1;
	}
	
	public final void calculateScanInfo(Collection<Enemy> robots, RobotStatus status) {
		
	}
	// End ScanInfo calculation
	// /////////////////////////////////
}
