package nat.gun.meteorite;

import java.util.ArrayList;
import java.util.List;

import nat.base.BotBase;
import nat.utils.M;
import nat.utils.Point;


public abstract class PIFView {
	private double bulletVelocity = 11d;
	private Point fireLocation = null;
	
	protected abstract void addPoint(ScanInfo scan, Trace trace);
	protected abstract List<PIFEntry> getPredictedPoint(ScanInfo lastScan, int size);
	
	public List<PIFLocation> getLocation(ScanInfo lastScan, Trace trace, int size, Point fireLocation, double bulletVelocity) {
		this.fireLocation = fireLocation;
		this.bulletVelocity = bulletVelocity;
		
		List<PIFEntry> predicts = getPredictedPoint(lastScan, Math.max(size * 4, 150));
		List<PIFLocation> results = new ArrayList<PIFLocation>(size);
		
		for (int i = predicts.size() - 1; i >= 0 && results.size() < size; i--) {
			PIFEntry entry = predicts.get(i);
			Point location = playItForward(entry.trace, trace);
			double tolerance = 20d / location.distance(fireLocation);
			double weight = 1 /* entry.distance */;
			double angle = fireLocation.angle(location);
			PIFLocation result = new PIFLocation(location, weight, tolerance, angle);
			results.add(result);
		}
		
		return results;
	}
	
	// play-it-forward code
	protected Point playItForward(Trace start, Trace current) {
		int currentRound = start.round;
		double distance = current.distance(fireLocation);
		double angle = current.angle(fireLocation);
		double deltaHeading = start.heading - current.heading;
		Point projectedMyLocation = M.project(start, angle + deltaHeading, distance);
		double bulletDistance = 0;
		int estimatedBFT = (int) M.ceil(distance / bulletVelocity);
		for (int i = 0; i < estimatedBFT; i++) {
			start = start.next;
			if (start == null || start.round != currentRound)
				return null;
			bulletDistance += bulletVelocity;
		}
		distance = start.distance(projectedMyLocation);
		int newBFT = (int) M.ceil(distance / bulletVelocity);
		distance *= distance;
		if (newBFT < estimatedBFT) {
			do {
				start = start.previous;
				bulletDistance -= bulletVelocity;
				distance = start.distanceSq(projectedMyLocation);
			} while (M.sqr(bulletDistance) > distance);
			start = start.next;
			bulletDistance += bulletVelocity;
			distance = start.distanceSq(projectedMyLocation);
		} else if (newBFT > estimatedBFT) {
			do {
				start = start.next;
				if (start == null || start.round != currentRound)
					return null;
				bulletDistance += bulletVelocity;
				distance = start.distanceSq(projectedMyLocation);
			} while (M.sqr(bulletDistance) < distance);
		}
		angle = projectedMyLocation.angle(start);
		distance = M.sqrt(distance);
		Point resultLocation = M.project(fireLocation, angle - deltaHeading, distance);
		if (!BotBase.BATTLEFIELD.contains(resultLocation)) {
			return null;
		}
		return resultLocation;
	}

	protected Point playItForwardNormal(Trace start, Trace current) {
		int currentRound = start.round;
		double distance = current.distance(fireLocation);
		double angle = current.angle(fireLocation);
		double deltaHeading = start.heading - current.heading;
		Point projectedMyLocation = M.project(start, angle + deltaHeading, distance);
		double bulletDistance = 0;
		do {
			start = start.next;
			if (start == null || start.round != currentRound)
				return null;
			bulletDistance += bulletVelocity;
			distance = start.distanceSq(projectedMyLocation);
		} while (M.sqr(bulletDistance) < distance);
		angle = projectedMyLocation.angle(start);
		distance = M.sqrt(distance);
		Point resultLocation = M.project(fireLocation, angle - deltaHeading, distance);
		if (!BotBase.BATTLEFIELD.contains(resultLocation)) {
			return null;
		}
		return resultLocation;
	}
}
