package nat.utils;

public final class Range {
	public final double upper, lower;

	public Range(double v1, double v2) {
		this.lower = M.min(v1, v2);
		this.upper = M.max(v1, v2);
	}

	public Range clone() {
		return new Range(lower, upper);
	}

	public Range grow(Range r) {
		return new Range(M.min(lower, r.lower), M.max(upper, r.upper));
	}
	
	public double getSize() {
		return (upper - lower);
	}

	public double getMean() {
		return (upper + lower) * 0.5;
	}

	public double distanceOutside(double n) {
		if (n > upper)
			return (n - upper);
		else if (n < lower)
			return (lower - n);
		else
			return 0;
	}
}
