package apv;

import robocode.*;
import java.awt.geom.Point2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Vector;
import java.io.*;
import java.util.zip.*;

import apv.nrlibj.NNet;
import apv.nrlibj.NrPop;

import java.awt.Color;

//import robocode.robocodeGL.system.GLRenderer;
//import robocode.robocodeGL.PointGL;
//import robocode.robocodeGL.LineGL;

/** ScruchiPuReloaded -  by Albert Prez 
* Uses external NeuralNetwork library (NRLIBJ) by Danielle Denaro
* Uses some code from Kawigi for dynamic distancing
*
* v 0.5	First release. New NN (trully a brain) and dynamic distancing added.
*
* When there exists a network, don't train after enough data is present
*		    
*/		  

public class TheBrainPi extends AdvancedRobot {
	
	static final int embed = 15; //30
	static final int delay = 5;
	static final float IN_SF = 400; //Input Vel. Scale factor
	static final float OUT_SFA = 800;
	static final float OUT_SFD = 120;
				
	//Original config = 60/20/20/2			
	static String NNdescr[]=    
		{"layer=0 tnode=60 nname=NodeLin",        
  		 "layer=1 tnode=60 nname=NodeSigm", 
		 "layer=2 tnode=20  nname=NodeSigm",       
  		 "layer=3 tnode=2   nname=NodeSigm",       
  		 "linktype=all fromlayer=0 tolayer=1",   
  		 "linktype=all fromlayer=1 tolayer=2",
		 "linktype=all fromlayer=2 tolayer=3"}; 
					
	static double[] fired = new double[100000];
	
	static Line2D[] ps = new Line2D[100000];
	static Vector inputs = null;
	static Vector outputs = null;
	static boolean difference = true;
	static boolean fileloaded = true;
	
	static MovSim futureMovement = new MovSim();
	
	static double currentEnergy;
	
	static double[] bearings = new double[100000];
	static double[] benefit = null;
	static double[] penalty = null;
	static int distanceindex, latv;

	static int n,m; 

	static String botname;
	static double predBearing;
	static double power;
	
	static double lastHeading; 
	static double eGetDistance;
	static double targetBearing;
	
	static NNet networkL = null; 
	
	public void run() {
		double nextMove, lastMove;
		double bestX, bestY, bestA;

		setAdjustRadarForGunTurn(true);	setAdjustGunForRobotTurn(true); 
		NrPop.setDefFlagBiasLearn(true); NrPop.setDefLearnFactor(0.3f);	NrPop.setDefMomentFactor(0.1f);
		//!!! Careful with momentum and learn (originally L = 0.1 and M = 0.0)!!!!
		
		nextMove = bestA = Math.PI; 
		lastMove = bestX = bestY = 2.0;
		power = 3;	
		predBearing = 0;
		
		currentEnergy = 100;
		
		m = Math.max(n-1,0);
		
		do {
			double x = getX();
			double y = getY();
			//MOVE
			if (++lastMove >= nextMove) {		
					nextMove = 1; 
					if ((lastMove=Math.atan(Math.tan((bestA=normalRelativeAngle(Math.atan2(bestX-x,bestY-y) - getHeadingRadians()))))) != bestA) {
						nextMove = -1.0; bestA = lastMove;
					}	
					setTurnRightRadians(bestA);
					setAhead(nextMove * Point2D.distance(bestX,bestY,x,y));
					nextMove = eGetDistance/17;
					bestA = Double.POSITIVE_INFINITY;	
					lastMove = 0;
			} else { 
				double nextX, nextY;
				y = Math.atan2((nextX=newpos(getBattleFieldWidth()))-x,(nextY=newpos(getBattleFieldHeight()))-y);
				if ((x = (2 * scoring(targetBearing-y)+ scoring(getHeadingRadians()-y))*onRange(nextX,nextY) ) < bestA ) {	
					bestX = nextX; bestY = nextY; bestA = x; 
				}
			}
			nextMove = Math.min(nextMove,eGetDistance/17);
			//RADAR
			if (getRadarTurnRemainingRadians() == 0) setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			execute();
		} while (true); 
		
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		botname = getBotClass(e.getName());
		if (networkL == null) {	
			//try { networkL = new NNet(botname+".L",false,this); } catch (Exception ex) { networkL = new NNet(NNdescr); fileloaded = false; }
			//readInfo(botname);	
			try { networkL = new NNet("AIMING",false,this); } catch (Exception ex) { networkL = new NNet(NNdescr); fileloaded = false; }
			readInfo("MOVEMENT");
		}	
		//RADAR
		setTurnRadarRightRadians(normalRelativeAngle((targetBearing=e.getBearingRadians() + getHeadingRadians())-getRadarHeadingRadians()) * 1.9);
		//ENEMY DATA (FOR FIRING & MOVING)
		eGetDistance = e.getDistance();
		ps[n] = new Line2D.Double(getX(),getY(),getX()+eGetDistance*Math.sin(targetBearing),getY()+eGetDistance*Math.cos(targetBearing));
		//ENEMY DATA (FOR DYNAMIC DISTANCING)
		distanceindex = (int)(eGetDistance/50);
		double denergy = currentEnergy-e.getEnergy();
		if (denergy >= .09 && denergy <= 3) { benefit[distanceindex] += denergy; }
		currentEnergy = e.getEnergy();
		//LEARN	
		//calculateGunBearings();
		if (getTime()>embed*delay+delay && e.getEnergy()>0 && getEnergy() > 3) learn(networkL,n);
		//AIMING
    // Original line before unofficial fix:
		// if (e.getEnergy()>0 && getTime() > embed*delay/2) predBearing = aim(networkL); else predBearing = targetBearing;

		/* Unofficial fix start */
    if (e.getEnergy()>0 && getTime() > embed*delay/2) {
      try { predBearing = aim(networkL); }
      catch ( Exception e_fix ) {
        File file = getDataFile("AIMING.zip");
        boolean deleted = file.delete();
        System.out.println("Unofficial fix hitted, aiming file deleted: " + deleted);
        try { networkL = new NNet("AIMING",false,this); } catch (Exception ex) { networkL = new NNet(NNdescr); fileloaded = false; }
        predBearing = aim(networkL);
      }
    }
    else predBearing = targetBearing;
    /* Unofficial fix end */

		
		setTurnGunRightRadians(normalRelativeAngle(predBearing-getGunHeadingRadians()));	
		
		//PointGL pt4 = new PointGL(); pt4.setPosition(getTime(),50+50*normalRelativeAngle(predBearing-targetBearing)); pt4.setSize(2); pt4.setColor(Color.green); GLRenderer.getInstance().addRenderElement(pt4);
		//PointGL pt5 = new PointGL(); pt5.setPosition(getTime(),50); pt5.setSize(1); pt5.setColor(Color.red); GLRenderer.getInstance().addRenderElement(pt5);
		
		//FIRING				
		if( getEnergy()>power && getEnergy()>0.3 && getGunHeat()==0 && getTime()>embed*delay/2) { setFire(power); fired[n]=predBearing;  } else fired[n] = Double.POSITIVE_INFINITY;  
		if( getEnergy()<=3) power = 0.2;

		n++;
		
	}	
	
	//******************************************************************************************************
	//Aiming functions
	//******************************************************************************************************
	
	/* public void calculateGunBearings() {
		for (int i=m+1; i<((int)n-1); i++) {	
			Line2D gun = new Line2D.Double(ps[i].getP1(),ps[i].getP2()); int j = 0;
			while (j*11.0 < gun.getP1().distance(gun.getP2())-20.0 && i+j<n ) { j++; gun.setLine(gun.getP1(),ps[i+j].getP2()); }
			if (i+j < n) {
				double angle = bearings[m] = normalRelativeAngle(Math.atan2(gun.getX2()-gun.getX1(),gun.getY2()-gun.getY1()) - Math.atan2(ps[i].getX2()-gun.getX1(),ps[i].getY2()-gun.getY1()));		
				//PRINT GRAPH
				double tolerance = Math.asin(50/ps[i].getP1().distance(ps[i].getP2()));	PointGL pme = new PointGL(); pme.setPosition(getTime()-n+m,50+angle*50+tolerance*50); pme.setColor(Color.white); GLRenderer.getInstance().addRenderElement(pme); PointGL pme2 = new PointGL(); pme2.setPosition(getTime()-n+m,50+angle*50-tolerance*50);	pme2.setColor(Color.white); GLRenderer.getInstance().addRenderElement(pme2);
				m++;
			}
		}
	} */				
		
	public void learn(NNet network, int n) {
		float[] input = buildInput(Math.max(n-delay,0)); float[] output = buildOutput(Math.max(n-delay,0),difference); 
		if (input != null && output !=null) { 
			inputs.add(input); outputs.add(output); Train(network, Math.max(Math.min(n/10,10),1)); 
		}
	}
	
	public double aim(NNet network) {
		float[] output = new float[2]; double lastX = (float) ps[n].getP2().getX(); double lastY = (float) ps[n].getP2().getY();
		MovSimStat[] nextp = futureMovement.futurePos(120, this); int time = 0;
		while ((20-3*power)*(time*delay)<Point2D.distance(getX(),getY(),lastX,lastY)) {
			float[] input = buildInput(n+time*delay);
			if (input != null) network.frwNNet(input,output); else { return targetBearing; }
			if (!difference) { lastX = output[0]*OUT_SFA; lastY = output[1]*OUT_SFA; }
			else { 
				Point2D fp = correctCoordenates(0,0,(output[0]-0.5) * OUT_SFD,(output[1]-0.5) * OUT_SFD); 
				lastX += fp.getX(); lastY += fp.getY(); 
			}
			//if (getGunHeat() == 0) { PointGL pt5 = new PointGL(); pt5.setPosition(lastX,lastY); pt5.setSize(2); pt5.setColor(Color.red); GLRenderer.getInstance().addRenderElement(pt5); }
	    /* Unofficial fix: added the try/catch clause */
      try {
        ps[n+(time+1)*delay] = new Line2D.Double(nextp[(time+1)*delay].x,nextp[(time+1)*delay].y,lastX,lastY);
      } catch ( Exception ex2 ) {
        break;
      }
			time++;
		}
		return Math.atan2(lastX-getX(),lastY-getY());
	}
		
	public void Train(NNet network, int num) {
		for (int i=0; i<num; i++) {
			int idx = (int) (Math.random() * inputs.size()); 
			float[] input = (float[]) inputs.get(idx); float[] output = (float[]) outputs.get(idx);
			network.ebplearnNNet(input,output); 
		}
	} 	
			
	public float[] buildInput(int n) {
		if (n<embed*delay) return null;
		else {
			float[] input = new float[4*embed];
			for (int i=0; i<embed; i++) { 
				input[4*i] = (float) ps[n-i*delay].getP1().getX()/IN_SF;
				input[4*i+1] = (float) ps[n-i*delay].getP1().getY()/IN_SF;
				input[4*i+2] = (float) ps[n-i*delay].getP2().getX()/IN_SF;
				input[4*i+3] = (float) ps[n-i*delay].getP2().getY()/IN_SF; 
			}
			return input;
		}
	}	
	
	public float[] buildOutput(int n, boolean difference) {
		if (n<0) return null;
		else { 
			float[] output = new float[2]; 
			if (!difference) { 
				output[0] = (float) ps[n+delay].getP2().getX()/OUT_SFA;	
				output[1] = (float) ps[n+delay].getP2().getY()/OUT_SFA;
			} else {
				output[0] = (float) ( (ps[n+delay].getP2().getX()-ps[n].getP2().getX())/OUT_SFD + 0.5 );
				output[1] = (float) ( (ps[n+delay].getP2().getY()-ps[n].getP2().getY())/OUT_SFD + 0.5 );
			}
			return output;
		}
	}	
	
	public Point2D correctCoordenates(double currX, double currY, double nextX, double nextY) {
		double heading = Math.atan2(nextX-currX,nextY-currY);
		double distance = Point2D.distance(currX, currY, nextX, nextY);
		if (distance > 40) return new Point2D.Double(currX+Math.sin(heading)*40,currY+Math.cos(heading)*40);
		else return new Point2D.Double(nextX,nextY);
	}
	
	//******************************************************************************************************
	//Helpers & general functions
	//******************************************************************************************************
				
	public void onWin(WinEvent event) { onDeath(null); }
	
	//public void onDeath(DeathEvent e) {	if (getRoundNum()==getNumRounds()-1) { networkL.saveNNet(botname+".L",this); writeInfo(botname); } }
	
	public void onDeath(DeathEvent e) {	if (getRoundNum()==getNumRounds()-1) { networkL.saveNNet("AIMING",this); writeInfo("MOVEMENT"); } }		
																																																																																																																																																																		
	private double normalRelativeAngle(double angle) { return ((angle + 5*Math.PI) % (2*Math.PI)) - Math.PI; }
	
	private double scoring(double a1) { return Math.abs(Math.abs(normalRelativeAngle(a1))-Math.PI/2); }		
		
	private double newpos(double len) { return 100 + Math.random()*(len-200); }	
	
	private String getBotClass(String name) { String n = name; int low = name.indexOf(" "); if (low >= 0) n = name.substring(0, low);  return n; }		
		
	//******************************************************************************************************
	//Kawigi's dynamic Distancing (only small changes from FloodMini)
	//******************************************************************************************************
	
	public double findBenefit(int index) { return (benefit[index]-penalty[index])/(benefit[index]+penalty[index]); }
	
	public double findDistanceBracket()	{
		int besti,i; i = besti = 4;
		do { if (findBenefit(i) > findBenefit(besti)) besti = i; i++; }	while (i <= 15);
		return 85 + besti*50;
	}
	
	public void onHitByBullet(HitByBulletEvent e) {	currentEnergy += e.getPower()*3; penalty[distanceindex] += Math.max(e.getPower()*7, e.getPower()*9-2); }
	
	public void onBulletHit(BulletHitEvent e) {	double p = e.getBullet().getPower(); currentEnergy -= Math.max(4*p, 6*p-2); benefit[distanceindex] += Math.max(4*p,6*p-2)+p*3; }
	
	public double onRange(double nextX, double nextY) {
		if (benefit == null) return 1.0;
		double npd = Point2D.distance(nextX,nextY,getX()+Math.sin(targetBearing)*eGetDistance,getY()+Math.sin(targetBearing)*eGetDistance);
		if (eGetDistance > findDistanceBracket()-120 && npd < eGetDistance) return 0.5;
		else if (eGetDistance < findDistanceBracket() && npd > eGetDistance) return 0.5; 
		else return 1.0;
	}
	
	public void readInfo(String name) {
		try {
			ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile(name+".M.zip"))));
			benefit = (double[])in.readObject(); penalty = (double[])in.readObject();
			inputs = (Vector)in.readObject(); outputs = (Vector)in.readObject();
			in.close();
		}
		catch (Exception e) { 
			benefit = new double[30];	penalty = new double[30]; 
			inputs = new Vector(); outputs = new Vector();
			out.println("No movement file"); }
	}	
	
	public void writeInfo(String name)	{
		Vector inp = new Vector();
		Vector oup = new Vector();
		for (int i=0; i<Math.min(800,inputs.size()); i++) {	int idx = (int) (Math.random()*inputs.size()); inp.add(inputs.get(idx)); oup.add(outputs.get(idx));	}
		try	{
			ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile(name+".M.zip"))));
			out.writeObject(benefit); out.writeObject(penalty);
			out.writeObject(inp); out.writeObject(oup);
			out.flush(); out.close();
		}
		catch (IOException e) { out.println("Error writting movement files");	}
	}			
				      
}										