package kawigi.spare;
import robocode.*;
import kawigi.spare.parts.*;
import kawigi.spare.util.*;
import java.awt.Color;
import javax.sound.sampled.*;
import java.io.*;
import java.util.zip.*;
/**
 * SpareParts - a robot by Kawigi, built from "spare parts"
 */
public class SpareParts extends AdvancedRobot
{
	public final static int GUN=0, MOVEMENT=1, RADAR=2, TARGETTER = 3;
	public static EnemyManager enemies;
	public static int hits, misses;
	public static PartSelector[] selector;
	private static double currentx, currenty;
	public static double fieldx, fieldy;
	private static long time;
	private boolean fatality, finish;
	private static final boolean sound=false;
	
	public double getBattleFieldWidth()
	{
		return fieldx;
	}
	
	public double getBattleFieldHeight()
	{
		return fieldy;
	}
	
	public double getX()
	{
		return currentx;
	}
	
	public double getY()
	{
		return currenty;
	}
	
	public long getTime()
	{
		return time;
	}
	
	public static GunSelector getGunSelector()
	{
		return (GunSelector)selector[GUN];
	}
	
	public static EnemyState getSelectedTarget()
	{
		return ((TargetChooser)((TargetSelector)selector[TARGETTER]).getSelectedPart()).chooseTarget();
	}
	
	public void run()
	{
		finish = fatality = false;
		setColors(Color.white,Color.gray,Color.black);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		if (fieldx == 0 && fieldy == 0)
		{
			fieldx = super.getBattleFieldWidth();
			fieldy = super.getBattleFieldHeight();
		}
		currentx = super.getX();
		currenty = super.getY();
		if (enemies == null)
			enemies = new EnemyManager(getOthers(), this);
		else
			enemies.resetRobot(this);
		if (selector == null)
		{
			selector = new PartSelector[4];
			selector[TARGETTER] = new TargetSelector(this, enemies);
			selector[MOVEMENT] = new MovementSelector(this, (TargetSelector)selector[TARGETTER]);
			selector[GUN] = new GunSelector(this, (TargetSelector)selector[TARGETTER], enemies);
			selector[RADAR] = new RadarSelector(this, (TargetSelector)selector[TARGETTER]);
		}
		time = super.getTime();
		while(true)
		{
			time = super.getTime();
			currentx = super.getX();
			currenty = super.getY();
			enemies.updateMe();
			for (int i=0; i<3; i++)
				selector[i].setAction();
			execute();
			EnemyState enemy = getSelectedTarget();
			if (enemy != null && enemy.getEnergy() == 0 && getOthers() == 1)
			{
				if (!finish && time > 100)
				{
					finish = true;
					playSound("FINSHHIM.wav");
				}
				fatality = true;
			}
			else
				fatality = false;
		}
	}
	
	public void onAnyEvent(Event e)
	{
		for (int i=0; i<selector.length; i++)
			selector[i].onEvent(e);
	}
	
	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e)
	{
		enemies.onScannedRobot(e);
		onAnyEvent(e);
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e)
	{
		onAnyEvent(e);
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		onAnyEvent(e);
		hits++;
	}
	
	public void onBulletMissed(BulletMissedEvent e)
	{
		onAnyEvent(e);
		misses++;
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e)
	{
		onAnyEvent(e);
	}
	
	public void onDeath(DeathEvent e)
	{
		onAnyEvent(e);
		printStats();
	}
	
	public void onHitWall(HitWallEvent e)
	{
		onAnyEvent(e);
	}
	
	public void onRobotDeath(RobotDeathEvent e)
	{
		onAnyEvent(e);
		enemies.kill(e.getName());
	}
	
	public void onWin(WinEvent e)
	{
		onAnyEvent(e);
		if (fatality)
			playSound("fatality.wav");
		else if (getNumRounds() == getRoundNum())
			playSound("IRULE.wav");
		else if (getEnergy() > 100)
			playSound("ALLEASY.wav");
		else
		{
			double rand = Math.random();
			if (rand < .33)
				playSound("mkda-laughing.wav");
			else if (rand < .67)
				playSound("IWIN.wav");
			else
				playSound("mkda-outstanding.wav");
		}
		printStats();
	}
	
	public void printStats()
	{
		System.out.println("hit rate: " + ((double)hits/(hits+misses)));
	}
	
	public void onSkippedTurn(SkippedTurnEvent e)
	{
		onAnyEvent(e);
	}
	
	public void onCustomEvent(CustomEvent e)
	{
		onAnyEvent(e);
	}
	
	public void playSound(String filename)
	{
		if (sound)
		{
			try
			{
				System.out.println("loading " + filename);
				ZipInputStream zipin = new ZipInputStream(new FileInputStream(getDataFile("sounds.zip")));
				ZipEntry current = zipin.getNextEntry();
				while (!current.getName().equals(filename))
					current = zipin.getNextEntry();
				AudioInputStream in = AudioSystem.getAudioInputStream(new BufferedInputStream(zipin));
				DataLine.Info info = new DataLine.Info(Clip.class, in.getFormat(), ((int)in.getFrameLength()*in.getFormat().getFrameSize()));
				Clip clip = (Clip) AudioSystem.getLine(info);
				clip.open(in);
				clip.setFramePosition(0);
				clip.loop(0);
				clip.drain();
				clip.flush();
				clip = null;
				System.out.println("played " + filename);
			}
			catch (Exception e)
			{
				System.out.println("Getting sound didn't work:");
				e.printStackTrace();
			}
		}
	}
}
