package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.SpareParts;
import kawigi.spare.util.*;
/**
 * LinearPredictingGun - a good gun for use against bots who move in straight lines
 */
public class LinearPredictingGun extends Gun implements java.io.Serializable
{
	private transient double power;
	public LinearPredictingGun(AdvancedRobot robot)
	{
		super(robot);
	}
	
	public void onEvent(Event e)
	{
	}
	
	public ChooserBullet getVirtualBullet(EnemyState target)
	{
		if (target == null)
			return null;
		if (robot.getEnergy() >= 15 || target.getEnergy() != 0)
			power=3;
		else
			power = robot.getEnergy()*.2;
		double myx = robot.getX(), myy = robot.getY();
		double bulletv = 20-3*power;
		//predict where they're going:
		double sine = target.getRecentAverageVelocity()/bulletv*Math.sin(Math.PI+target.getAbsoluteBearing(myx, myy)-target.getHeading());
		double theta = Math.asin(sine)+target.getAbsoluteBearing(myx, myy);
		
		//try and detect if the enemy will hit the wall:
		double finalangle = Math.PI - Math.abs(theta) - (Math.PI+target.getAbsoluteBearing(myx, myy)-target.getHeading());
		//	distance/sine(finalangle) == enemydistance/sine(theta)
		double enemydistance = sine*target.getDistance(myx, myy)/Math.sin(finalangle);
		//find their current position
		double enemyStartX = target.getX();
		double enemyStartY = target.getY();
		//find their final destination
		double endX = enemyStartX + enemydistance*Math.sin(target.getHeading());
		double endY = enemyStartY + enemydistance*Math.cos(target.getHeading());
		//figure out if they're off the screen, using offsets like David did above
		if (endX < 18 || endY < 18 || endX > robot.getBattleFieldWidth()-18 || endY > robot.getBattleFieldHeight()-18)
		{
			// now I'm going to try and find an equation for the line the opponent follows to find where it intersects with the edge.
			// finding the slope:
			double m = Math.atan(target.getHeading());
			//finding the y-intercept:
			double b = enemyStartY-enemyStartX*m;
			//now if I went off a side wall, this part is easy...
			if (endX < 18)	//plug 18 in as x (in my equation, which is in y=mx+b form)
			{
				endX = 18;
				endY = m*endX+b;
			}
			else if (endX > robot.getBattleFieldWidth()-18)
			{
				endX = robot.getBattleFieldWidth()-18;
				endY = m*endX+b;
			}
			//now for the top/bottom cases:
			if (endY < 18)
			{
				endY = 18;
				//now solve for x:
				endX = (endY-b)/m;
			}
			else if (endY > robot.getBattleFieldHeight()-18)
			{
				endY = robot.getBattleFieldHeight()-18;
				endX = (endY-b)/m;
			}
			//figure out the time before they hit the wall:
			double time = Math.sqrt((endX-enemyStartX)*(endX-enemyStartX)+(endY-enemyStartY)*(endY-enemyStartY))/target.getRecentAverageVelocity();
			//now find how fast our bullet would have to be to hit them then:
			double newbulletv = Math.sqrt((endX-myx)*(endX-myx)+(endY-myy)*(endY-myy))/time;
			if (newbulletv <= 19.7)
				power = (20-newbulletv)/3;
			else
				power = .1;
			//now adjust theta to aim at (endX, endY):
			theta = Math.atan2(endX-myx, endY-myy);
		}
		return new ChooserBullet(target.getName(), myx, myy, theta, power, this, robot.getTime());
	}
}
