package kawigi.spare.parts;
import kawigi.spare.util.*;
import robocode.*;

public class TargetSelector extends PartSelector implements java.io.Serializable
{
	private TargetChooser[] choosers;
	private int[] wins, losses;
	private int index;
	private AdvancedRobot robot;
	
	public TargetSelector(AdvancedRobot robot, EnemyManager manager)
	{
		this.robot = robot;
		choosers = new TargetChooser[5];
		choosers[0] = new ClosestTargetChooser(robot, manager);
		choosers[1] = new SmearQueerTargetChooser(robot, manager);
		choosers[2] = new VengenceTargetChooser(robot, manager);
		choosers[3] = new EasyTargetChooser(robot, manager);
		choosers[4] = new KickWhileDownTargetChooser(robot, manager);	//this one doesn't seem to be very effective.
		wins = new int[choosers.length];
		for (int i=0; i<wins.length; i++)
			wins[i] = 1;
		losses = new int[choosers.length];
	}
	
	public EnemyState getClosestEnemy()
	{
		return choosers[0].chooseTarget();
	}
	
	public void giveGunSelector(GunSelector guns)
	{
		((EasyTargetChooser)choosers[3]).giveGunSelector(guns);
	}
	
	public void onEvent(Event e)
	{
		if (e instanceof WinEvent)
		{
			wins[index]++;
			System.out.println("won with targetting strategy " + index);
		}
		else if (e instanceof DeathEvent)
		{
			losses[index]++;
			System.out.print("lost with targetting strategy " + index);
			int ind = 0;
			for (int i=1; i<choosers.length; i++)
				if ((double)wins[i]/(wins[i]+losses[i]) > (double)wins[ind]/(wins[ind]+losses[ind]))
					ind = i;
			index = ind;
			System.out.println(", now trying targetting strategy " + index);
		}
		for (int i=0; i<choosers.length; i++)
			choosers[i].onEvent(e);
	}
	
	public Part getSelectedPart()
	{
		return choosers[index];
	}
}
