/*
 * Created on Sep 9, 2004
 *
 */
package davidalves.net.gun.segmentation;

import davidalves.PhoenixOS;
import davidalves.net.util.RobotState;

/**
 * @author David Alves
 *
 */
public abstract class LinearSegmentation extends Segmentation {
	
	boolean maxClampingOk;
	boolean minClampingOk;
	
	double min = 0;
	double max = 1;
	
	int numSegments;
	
	private LinearSegmentation(){}
	
	public LinearSegmentation(double min, double max, boolean minClampingOk, boolean maxClampingOk, int numSegments){
		this.min = min;
		this.max = max;
		this.minClampingOk = minClampingOk;
		this.maxClampingOk = maxClampingOk;
		this.numSegments = numSegments;
	}
	
	protected abstract double getValue(RobotState shooter, RobotState target, double bulletPower);
	
	public final int numSegments() {
		return numSegments;
	}

	public final int getSegment(RobotState shooter, RobotState target, double bulletPower) {
		double value = getValue(shooter, target, bulletPower);
		
		int segment = (int) Math.floor(numSegments * (value - min) / (max - min));
		
		//This line allows our range to be inclusive... value can equal max, even without max clamping enabled
		if(segment == numSegments && value == max) return numSegments - 1;
		
		//If it's ok to clamp to the min value and we need to, do so.
		if(minClampingOk && segment < 0) segment = 0;
		
		//If it's ok to clamp to the max value and we need to, do so.
		if(maxClampingOk && segment >= numSegments) segment = numSegments - 1;
		
		//Throw an exception if it's out of range and clamping is not allowed... probably means that getValue() is buggy
		if((segment >= numSegments) || segment < 0) throw new RuntimeException(min + " " + value + " " + max);
		
		return segment;
	}

}
