package dft.bin;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class WaveManager extends ArrayList {	
	
	private static final long serialVersionUID = 6503325024551392764L;

	public void update(State s) {
		for (int i = 0; i < size();) {
			Wave w = (Wave)get(i); 
			Point2D location = w.isGunWave()?s.getEnemyLocation():s.getRobotLocation();
			if (w.update(location,s.getRobot().getTime())) {
				double GF = Utils.getGF(Utils.normalRelativeAngle(
						Utils.absoluteBearing(w.waveOrigin,w.targetLocation)-w.angle),
						w.escapeEnvelope);
			//	if (w.isGunWave()) System.out.println(w.targetLocation +" " +  s.getEnemyLocation());
				if (w.isGunWave()) w.increment(GF);
				//System.out.println(GF);
				remove(i);
			}
			else {
				i++;
			}
		}
	}
	
	public void onPaint(java.awt.Graphics g) {
		//System.out.println(size());
		for (int i = 0; i < size();i++) {
			MoveWave w = (MoveWave)get(i);
			//if (w.real) {
				Point2D p = w.waveLocation;
				g.setColor(Color.green);					
				int radius=(int)p.distance(w.waveOrigin);	
				//g.drawOval((int)(w.waveOrigin.getX()-4),(int)(w.waveOrigin.getY()-4),8,8); 
				//g.drawOval((int)(w.waveOrigin.getX()-radius),(int)(w.waveOrigin.getY()-radius),
				//		radius*2,radius*2);
				//g.setColor(Color.red);
				//g.drawOval((int)(p.getX()-2),(int)(p.getY()-2),4,4); 
				//g.drawString(w.probability+"",(int)(p.getX()+20),(int)(p.getY()-2));
				/*for (int j = 0; j < 51; j++) {
					Point2D l = Utils.project(w.waveOrigin,w.angle+((j/25.0)-1)*w.escapeEnvelope,w.waveOrigin.distance(w.waveLocation));
					g.setColor(Color.yellow);
					g.drawOval((int)(l.getX()-2),(int)(600-l.getY()-2),4,4); 
				}*/
				double[] val = (double[])w.realBuffers.get(0);
				for (int j = 1; j < val.length; j++) {
					p = Utils.project(w.waveOrigin,w.angle+(j-(val.length-1)/2)/(double)((val.length-1)/2)*w.escapeEnvelope,radius);
					int size = 2;
					if (val[j]==0) g.setColor(Color.green);
					else if (val[j]<0.075) g.setColor(new Color(125,255,0));
					else if (val[j]<0.15) g.setColor(new Color(255,255,0));
					else if (val[j]<0.225) g.setColor(new Color(255,125,0));
					else {
						g.setColor(Color.red);
						if (val[j]<0.3)
							size = 2;
						else if (val[j]<0.4)
							size = 3;
						else if (val[j]<0.5)
							size = 4;
						else
							size = 5;
					}
					if (val[j]>0)
					g.drawOval((int)(p.getX()-size),(int)(p.getY()-size),size*2,size*2); 
					
				}
			//}
		}
	}	
	
	public void setReal(int ticks) {
		if (size()+ticks>=0) {
			Wave w = (Wave)get(size()+ticks);
			w.real=true;
		}
	}
	
}
