package lancel.components;
import java.awt.geom.*;
import robocode.*;
import static java.lang.Math.*;

/**************************************************************************************************
 Lynx - A duelist, based on Dynamic Clustering (DC) and WaveSurfing
 Author: lancel
 Current Version: 1.09
 Date: 6/12/2010
 License: Open Source under the RoboWiki Public Code License RWPCL (http://robowiki.net/wiki/RWPCL)
 Robocode Version: 1.6.1.4 (because of RoboRumble)
 Techniques this bot is based on:
    Gun: a k-nearest neighbors search with a kd-tree using a simple kernel density estimation 
         (dynamic clustering)
    Movement: basic WaveSurfing using the closest wave as a surfing wave
 CREDITS: Much of the ideas and code is based on various sources. A few to mention:
    wiki.BasicGFSurfer by Voidius, Pez and Bayen: initial structure for Lynx and the implementation
        of WaveSurfing
    Komarious by Voidius: the segmentation for WaveSurfing
    ABC: inventor of WaveSurfing
    Rednaxela: the implementation of the kd-tree
    rozu: precise prediction used in the Lynx's movement system
    DrussGT by Skilgannon: normalizing and weighting "features" that describe states for the gun
        ("segmentation" in DC) 
    Raiko by Jamougha: choosing a bullet power
    PEZ: Simple Iterative Wall Smoothing
    Voidious and others: good tutorials for getting into robocoding
**************************************************************************************************/

public class State {
//-------------------------------------------------------------------------------------------------
// State is a class for collecting general state information about the game environment to one 
// location for attempting better clarity of state information handling. All variables are public 
// because of laziness to use getters and setters.

        // Basic states, that game physics gives us.
        public double  bearingToOpp; // All angles are in radians.
        public double  gunHeading;
        public double  myHeading;
        public double  myEnergy;
        public double  myVelocity;
        public double  oppDistance;
        public double  oppEnergy;
        public double  oppFirePower;
        public double  oppHeading;
        public double  oppVelocity;
        public long    time;
        public int     roundNum;
        public int     numRounds;
        public String  oppName;
        public Point2D.Double myLocation  = new Point2D.Double();
        public Point2D.Double oppLocation = new Point2D.Double();
        public String  myName;

    public void updateState(AdvancedRobot myState, ScannedRobotEvent oppState) {
    //---------------------------------------------------------------------------------------------
        // Update states in every tick.
        bearingToOpp    = oppState.getBearingRadians() + myState.getHeadingRadians();
        gunHeading      = myState.getGunHeadingRadians();
        myEnergy        = myState.getEnergy();
        myHeading       = myState.getHeadingRadians();
        myLocation      = new Point2D.Double(myState.getX(), myState.getY());
        myVelocity      = myState.getVelocity();
        oppDistance     = oppState.getDistance();
        oppEnergy       = oppState.getEnergy();
        oppHeading      = oppState.getHeadingRadians();
        oppVelocity     = oppState.getVelocity();
        oppLocation     = MyUtils.project(myLocation, bearingToOpp, oppDistance);
        roundNum        = myState.getRoundNum();
        time            = myState.getTime();
    }
} 
