package tobe.movement;
import tobe.platform.*;
import tobe.statistics.*;
import tobe.util.*;
import robocode.*;

public class Leaf implements Movement
{
	public void go(CommandCentre cc) {
		AdvancedRobot bot = cc.getBot();
		double x = bot.getX();
		double y = bot.getY();
		boolean newMove = false;
		double movementNormal = 0;
		TargetStatistics target = cc.getPreferredTarget();
		if(target != null) movementNormal = target.getBearing(x,y);
		java.util.Iterator i = cc.getTargetStatisticsIterator();
		while( i.hasNext() ) {
			target = (TargetStatistics) i.next();
			if(target.firedBullet(bot.getTime()) > 0) {
				bot.setMaxVelocity(2+random.nextInt(3)*3);
				if(random.nextDouble() < 0.25) newMove = true;
				if(random.nextDouble() < 0.25) movementNormal = target.getBearing(x,y);
			}
		}
			newMove = newMove || bot.getDistanceRemaining() == 0 ||
			  (wasWithinBounds && !safetyBounds.contains(x,y));

			//move ahead a little randomly if the previous move is done or if nearing a wall; we have to check that ourselves in an AdvancedRobot
			if(newMove) {
				bot.setAhead(move * (random.nextDouble()+0.1));
				//reverse direction next time
				move = -move;
			}
						
			//if I don't check if turn is complete, I will update my turn/heading continuously; In this case I don't want to, some other time I will
			//if I don't check if move is nearing completion, I will also almost get a (almost) continuous update of direction
			//if I wentOut, I also want to rethink my move right away
			if(newMove || !safetyBounds.contains(x,y) || Math.abs(bot.getDistanceRemaining()) < 60) {
				double turn = movementNormal;
				//if reversing, "look in the mirror"
				if(move > 0) turn = turn + Math.PI;
				//what must I turn to get there
				turn = BearingVector.normalizeAngle(turn - bot.getHeadingRadians());//call normalAngle for the shortest way round the circle
				turn += (turn < 0) ? attackAngle : -attackAngle;
			
				bot.setTurnRightRadians(turn);
			}
			
			wasWithinBounds = safetyBounds.contains(x,y);
			newMove = false;
	}
	
	public void init(CommandCentre cc) {
		safetyBounds.setRect(margin, margin, cc.getBot().getBattleFieldWidth()-2*margin, cc.getBot().getBattleFieldHeight()-2*margin);
		cc.getBot().setMaxVelocity(8);
		move = Math.max(cc.getBot().getBattleFieldWidth(), cc.getBot().getBattleFieldHeight());
		margin = 1.5*cc.getBot().getWidth();
	}
	
	static java.awt.geom.Rectangle2D.Double safetyBounds = new java.awt.geom.Rectangle2D.Double();
	java.util.Random random = new java.util.Random();
	boolean wasWithinBounds;
	double move;
	double margin;
	final static double attackAngle = Math.toRadians(70);
}
