package tobe.calypso;
import robocode.*;
import java.awt.Color;

/**
 * Calypso - a robot by Torbjorn Gannholm
 * named for a small satellite of Saturn
 *
 * version 4.1 improved movement (?) and power management
 *
 * Thanks to the following:
 * Martin Lepsoy
 * Daniel Pereira
 * Alcatraz 
 * Stuart Holliday
 * and a general thanks to all NanoBot developers for being so creative
 */

public class Calypso extends AdvancedRobot
{
	public void run() {
		setColors(Color.yellow, Color.black,Color.red);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double bearing;
		bearing = e.getBearingRadians();
		setTurnLeftRadians(Math.tan(bearing));
		bearing += getHeadingRadians();
		setTurnRadarLeft(getRadarTurnRemaining());
		b = new VirtualBullet(b, e.getDistance());
		setTurnGunRightRadians(Math.sin(bearing + b.update(e.getVelocity()*Math.sin(e.getHeadingRadians()-bearing), 1,0) - getGunHeadingRadians()));
		setAhead(getDistanceRemaining() + (Math.random()+Math.random()-1.0)*e.getDistance()*(6d/11d));
		fire(e.getEnergy()/4d);
	}
	
	VirtualBullet b;
}
