package dummy.mini;
import robocode.*;
import java.util.Arrays;

public class EnemyHistory
{
	public ScannedRobotEvent e;
	public long time;
	public int patterns[][][][];
	public int h[];
	public double myHeading;
	public double X;
	public double Y;
	public boolean live;
	
	public EnemyHistory()
	{
		this.patterns = new int[17][17][17][17];
		this.h = new int[4];
		Arrays.fill(h, 8);
		this.live = true;
	}

	public void addDisplacement(int displ)
	{
		displ = Math.min(Math.max(displ, -8), 8);
		patterns[h[0]][h[1]][h[2]][h[3]] = displ;
		h[0] = h[1];
		h[1] = h[2];
		h[2] = h[3];
		h[3] = displ+8;
	}
		
	public int[] nextmove(int[] p)
	{
		int nm[] = new int[4];
		nm[0] = p[1];
		nm[1] = p[2];
		nm[2] = p[3];
		nm[3] = patterns[p[0]][p[1]][p[2]][p[3]] + 8;
		return nm;
	}	
	
	public double aim(double distance, double bVelocity)
	{
		double displacement = 0;
		int history[] = (int[])h.clone(); 
		int t = (int)(distance/bVelocity);
		for (int i = 4; i < t; i+=8)
		{
			history = nextmove(history);
			displacement+= 8 * (history[3] - 8);
		}
		return displacement;
	}
}