package zzx;
import robocode.*;
//import java.awt.Color;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * Gron - a robot by (your name here)
 */
public class Gron extends AdvancedRobot
{
	//double turnDirection = 1;  //turning direction for ramming
	double moveDirection = 1;  //moving direction for ramming
	double i = 0;
	double previousEnergy = 100;  //energy sensing code
	/**
	 * run: Gron's default behavior
	 */
	public void run() {		
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		while(true) {
			// Replace the next 4 lines with any behavior you would like
			turnRadarRight(360);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		// Replace the next line with any behavior you would like
		double absoluteBearing=e.getBearingRadians() + getHeadingRadians();
		//setTurnRadarRightRadians((absoluteBearing - getRadarHeadingRadians()));
		//double alpha = getGunHeading() - getHeading();
		setTurnRadarRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing-getRadarHeadingRadians()) * 20);
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing-getGunHeadingRadians()) * 2);
		//setTurnGunRight(e.getBearing() - alpha);
		fire(3);
		double cIE = previousEnergy - e.getEnergy();
		if (cIE > 0) {
			i++;
			if (i > Math.random() * 20 + 10) {
				moveDirection *= -1;
				i = 0;
				previousEnergy = e.getEnergy();
			}
		}
		setAhead(90 * moveDirection);
		setTurnRight(e.getBearing() - 90);
	}	
	public void onHitWall(HitWallEvent e) {
		moveDirection *= -1;
	}			
}
