package voidious.twin;

import robocode.*;
import robocode.util.Utils;

import java.util.HashMap;
import java.util.ArrayList;
import java.awt.geom.Point2D;
import java.awt.Color;
import java.io.Serializable;
import java.util.Random;

/**
 * LuminariousDuo - a 2-bot team by Voidious
 *
 * Designed for the Twin Duel, http://robowiki.net/?Twin_Duel
 * Employs a Minimum Risk movement tailored to 2v2 and a GuessFactor
 * Targeting gun with Visit Count Stats. 
 * 
 * Code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/?RWPCL
 */

public class Luminarious extends TeamRobot {
    protected static final double RADAR_TRACK_AMOUNT = Math.PI/4;

    protected static Point2D.Double _myLocation;
    protected static Point2D.Double _teammateLocation;
    protected ArrayList _recentLocations;
    protected static java.awt.geom.Rectangle2D.Double _fieldRect;
    
    protected static HashMap _enemies = new HashMap();
    protected boolean _amLeader = true;
    protected static int _radarDirection = 1;
    protected static boolean _radarLock = false;
    protected int _teammatesAlive = 1;
    
    /* For now, we are assuming our enemies will use the same or similar
     * movement, which seems pretty likely.
     */

    protected static final double WAVE_BULLET_POWER = 2;
    protected static final double WAVE_BULLET_VELOCITY = 14;
    protected static final double WAVE_MAX_ESCAPE_ANGLE = 0.6082;
    protected static double _bulletPower;
    static final int GF_ZERO = 18;
    static final int GF_ONE = 36;
    static long[][][][][][] _gunStats = new long[4][2][2][4][5][GF_ONE+1];

    protected double _targetDistance = Double.POSITIVE_INFINITY;
    protected static String _targetName = "";
    protected static double _randomDirChangeAmount;
    protected long _timeSinceDirChangeCounter;
    protected static double _lastHeading;
    protected static double _enemyAbsoluteBearing;
    protected static int _lastGunOrientation;
    protected static double _lastDistance;
    protected static double _lastBulletPower = 1;
    protected static boolean _detectedDroid = false;
    
    public void run() {
    	_fieldRect = new java.awt.geom.Rectangle2D.Double(30, 30, 
            getBattleFieldWidth() - 60, getBattleFieldHeight() - 60);
        _recentLocations = new ArrayList();
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        setColors(Color.black, Color.black, new Color(80, 150, 80));
        
        do {
            try {
                broadcastMessage(new LuminariLocation(getX(), getY()));;
            } catch (Exception ex) { }

            if (Math.abs(getGunTurnRemaining()) < 4) {
            	setFireBullet(_bulletPower);
            }

            doRadar();
            setTurnRadarRightRadians(_radarDirection * RADAR_TRACK_AMOUNT);
            _radarLock = false;
            move();
            execute();
        } while (true);
    }
    
    public void onScannedRobot(ScannedRobotEvent e) {
        String eName = e.getName();
        double eDistance = _lastDistance = e.getDistance();
        double eVelocity = e.getVelocity();
        
        if (isTeammate(eName)) { return; }


        ////////////////////////////////////////////////
        // General data stuff
        ////////////////////////////////////////////////
        
        double enemyAbsoluteBearing = _enemyAbsoluteBearing = e.getBearingRadians() + getHeadingRadians();
        double enemyLatVel = eVelocity * 
        	Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing);
        if (!_enemies.containsKey(eName)) {
        	_enemies.put(eName, new EnemyData());
        }
        EnemyData eData = (EnemyData)_enemies.get(eName);
        if (getTime() < 10 && e.getEnergy() % 100 == 20) {
            _detectedDroid = eData.isDroid = true;
        }
        eData.name = eName;
        eData.setLocation(project(_myLocation, enemyAbsoluteBearing, eDistance));
        eData.energy = e.getEnergy();
        eData.heading = e.getHeadingRadians();
        eData.velocity = eVelocity;
        eData.lastScanTime = getTime();


        ////////////////////////////////////////////////
        // Radar
        ////////////////////////////////////////////////

        if (_enemies.size() == 1 ||
        	getGunHeat() <= 0.7 && _targetName.equals(eName)) {
        	
            _radarLock = true;
        }        
        
        ////////////////////////////////////////////////
        // Gun wave creation
        ////////////////////////////////////////////////

        MicroWave w;
        addCustomEvent(w = new MicroWave());
        w.targetName = eName;
        w.sourceLocation = _myLocation;
        w.directAngle = enemyAbsoluteBearing;
        w.orientation = _lastGunOrientation = sign((eVelocity)*Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing));

        w.waveGuessFactors = _gunStats[gunWallDistance(0.18247367367) ? (gunWallDistance(0.36494734735) ? (gunWallDistance(0.63865785787) ? 3 : 2) : 1) : 0][gunWallDistance(-0.36494734735) ? 0 : 1][(int)(Math.abs(Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing)) * 1.999)][(int)Math.min(3, (eDistance+50) / 200)][(int)((Math.abs(enemyLatVel)+1)/2)];
        
        
        ////////////////////////////////////////////////
        // Target selection and actual firing.
        ////////////////////////////////////////////////

        if (eDistance * (eData.isDroid ? 2 : 1) < _targetDistance || 
            _targetName.equals(eName)) {
        	
        	_targetDistance = eDistance;
            _targetName = eName;
        }

        if (!_targetName.equals(eName)) {
            return; 
        } 
        
        int bestGF = GF_ZERO;
        double bestGFRank = 0;
        for (int x = 0; x < GF_ONE; x++) {
        	if (w.waveGuessFactors[x] > bestGFRank) {
        		bestGFRank = w.waveGuessFactors[x];
        		bestGF = x;
        	}
        }
        
         _bulletPower = 1.999;

        if (eDistance > 750) {
        	_bulletPower = 1.499;
        }

        if (getEnergy() < 25) {
        	_bulletPower = Math.min(_bulletPower, 2 - Math.max(0, (35 - getEnergy()) / 18));
        }

        if (eDistance < 150 || _detectedDroid) {
            _bulletPower = 3;
        }

        setTurnGunRightRadians(Utils.normalRelativeAngle(
        		enemyAbsoluteBearing - getGunHeadingRadians() +
        		(e.getEnergy() > 0 ?
        			(w.orientation 
        			* (maxEscapeAngle(Rules.getBulletSpeed(_bulletPower)) / GF_ZERO)
        			* (bestGF - GF_ZERO)) : 0)));        
    }

    public void onMessageReceived(MessageEvent e) {
    	LuminariLocation loc = (LuminariLocation)e.getMessage();
        _teammateLocation = new Point2D.Double(loc.x, loc.y);
    }
    
    public void onRobotDeath(RobotDeathEvent e) {
    	String eName = e.getName();
    	
        if (isTeammate(eName)) {
            _teammatesAlive--;
        }
        
        if (_targetName.equals(eName)) {
            _targetName = "";
            _targetDistance = Double.POSITIVE_INFINITY;
        }
        
        _enemies.remove(eName);
    }
    
    public void onHitByBullet(HitByBulletEvent e) {
        _lastBulletPower = e.getPower();
    }
    
    public void onHitWall(HitWallEvent e) {
    	_timeSinceDirChangeCounter = 0;
    }
    
    protected void doRadar() {
        if (_radarLock) {
            _radarDirection *= -1;
            return;
        }
        try {
            Object[] enemies = 
                (_enemies.values().toArray());
            EnemyData scanTarget = (EnemyData)enemies[0];
            EnemyData otherTarget = (EnemyData)enemies[1];
            if (otherTarget.lastScanTime < scanTarget.lastScanTime) {
                scanTarget = otherTarget;
            }
            
            double radarTurnDistance = Utils.normalRelativeAngle(
                absoluteBearing(_myLocation, scanTarget) -
                    getRadarHeadingRadians());
            int newScanDirection = sign(radarTurnDistance);
            if (_radarDirection == newScanDirection || 
                getTime() == scanTarget.lastScanTime ||
                Math.abs(radarTurnDistance) > RADAR_TRACK_AMOUNT) {
                _radarDirection = newScanDirection;
            }
        } catch (Exception ex) { }
    }
    
    protected void move() {
        Point2D.Double myLocation = _myLocation = new Point2D.Double(getX(), getY());       

        if (Math.random() > 0.9) {
        	_recentLocations.add(0, myLocation);
        }
        
        double currentHeading =
            getHeadingRadians() + (getVelocity() < 0?Math.PI:0);
        double bestRisk = Double.POSITIVE_INFINITY;
        double bestAngle = 0;
        
        Object[] enemies = 
            (_enemies.values().toArray());
        
        if (Math.abs(Utils.normalRelativeAngle(currentHeading - _lastHeading)) 
           	< Math.PI / 3) {
           	_timeSinceDirChangeCounter++;
        } else {
        	_timeSinceDirChangeCounter = 0;
        	_randomDirChangeAmount =
        		Math.max(4, 2 * Math.random() * Math.random() * (_targetDistance / Rules.getBulletSpeed(_lastBulletPower)));
        }
        
        for (double x = 0; x < 2; x += .04) {
            double testAngle = x * Math.PI;
            Point2D.Double testPoint = project(myLocation, testAngle, 
                50 + Math.random() * 200);
            
            if (_fieldRect.contains(testPoint)) {
                double testRisk = 0;
                
            	double[] enemyBearings = new double[2];
                for (int y = 0; y < enemies.length; y++) {
                    EnemyData eData = ((EnemyData)enemies[y]);
                    double distSquaredToEnemy;
                    
                    testRisk += 
                        ((limit(0.1, (eData.energy / getEnergy()), 2)
                        	/ (distSquaredToEnemy = testPoint.distanceSq(eData)))
                        	+ ((2 * _teammatesAlive) / testPoint.distanceSq(_teammateLocation))
                        )
                        * (!_detectedDroid || getOthers() < 3 || _amLeader ? 1 : (
                        	(Math.max(1.3, square(distSquaredToEnemy / _teammateLocation.distanceSq(eData))))))
                        * (1 + square(Math.cos(absoluteBearing(
                            myLocation, eData) - testAngle)))
//                        * (2 + square(Math.sin(absoluteBearing(
//                        		testPoint, eData) - eData.heading)))
                        * (_teammatesAlive==0?1:(1 + square(Math.cos(
                            absoluteBearing(eData, _teammateLocation) - 
                                (enemyBearings[y] = 
                                    absoluteBearing(eData, testPoint))))))
                        ;
                }
                
                try {
                	if (_enemies.size() == 2) {
                		testRisk *= (1 + square(Math.sin(enemyBearings[0] - enemyBearings[1])));
                	}
                } catch (Exception e) { }
                
            	if (Math.abs(Utils.normalRelativeAngle(currentHeading 
                    	- testAngle)) < (Math.PI / 3)) {
            		if (_timeSinceDirChangeCounter > _randomDirChangeAmount) {
                		testRisk *= 10;
                	} else {
                		testRisk /= 2;
                	}
                }
            	
                try {
                    for (int z = 0; z < Math.min(6, _recentLocations.size()); z++) {
                    	testRisk *= (1 + (((1000) - (100 * z)) / (testPoint.distanceSq((Point2D.Double)_recentLocations.get(z)))));
                    }
                } catch (Exception e) { }
                                
                if (testRisk < bestRisk) {
                    bestRisk = testRisk;
                    bestAngle = x * Math.PI;
                }        
            }           
        }

        _lastHeading = currentHeading;

        moveWithBackAsFront(bestAngle);
    }
       
    // CREDIT: code by Iiley,
    // http://robowiki.net?BackAsFront
    void moveWithBackAsFront(double goAngle) {
        double angle;
        setTurnRightRadians(Math.tan(angle = goAngle - getHeadingRadians()));
        setAhead(Math.cos(angle) * Double.POSITIVE_INFINITY);
    }
     
    protected static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }
        
    private static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    static int sign(double d) {
        if (d >= 0) return 1;
        return-1;
    }

    static double square(double d) {
        return d * d;
    }

    private static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0/velocity);
    }

    protected static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    protected static double pythago(double x, double y) {
    	return Math.sqrt(square(x) + square(y));
    }
   
    protected static boolean gunWallDistance(double wallDistance) {
        return _fieldRect.contains(project(_myLocation, _enemyAbsoluteBearing + (_lastGunOrientation*wallDistance), _lastDistance));
    }

    class MicroWave extends Condition {
        String targetName;
        Point2D.Double sourceLocation;
        long[] waveGuessFactors;
        double bulletVelocity, directAngle, distance;
        int orientation;

        public boolean test(){
        	try {
                Point2D.Double enemyLocation = 
                    ((EnemyData)_enemies.get(targetName));
                if ((enemyLocation).distance(sourceLocation)
                    <= (distance+=WAVE_BULLET_VELOCITY) + (WAVE_BULLET_VELOCITY/2)) {
                	try {
                		double guessFactor = (Utils.normalRelativeAngle(
                				absoluteBearing(sourceLocation, enemyLocation)
                				- directAngle) * orientation) / WAVE_MAX_ESCAPE_ANGLE;
                		int guessFactorIndex = (int)((guessFactor * GF_ZERO) + GF_ZERO);
                		waveGuessFactors[guessFactorIndex]++;
                	} catch (Exception e) { }
                    removeCustomEvent(this);
                }
        	} catch (Exception e) { }
            return false;
        }
    }
}

class EnemyData extends Point2D.Double {
    boolean isDroid = false;
    String name;
    double energy, velocity, heading;
    long lastScanTime;
}

class LuminariLocation implements Serializable {
    public double x;
    public double y;
    
    public LuminariLocation(double newX, double newY) {
        x = newX;
        y = newY;
    }
}
