.version 61 0
.class public super d414/nano/Quantum
.super robocode/AdvancedRobot

; --------------------------------------------------------------------------------------------------
; ==============
; Quantum (Nano)
; ==============
; Author: David414
; License: RWPCL (https://robowiki.net/wiki/RWPCL)
; Credits: Mike Dorgan's bots DustBunny and Infinity
; --------------------------------------------------------------------------------------------------

; --------------------------------------------------------------------------------------------------
; Version History
; --------------------------------------------------------------------------------------------------
; ==================================================================================================
; v0.2.2 (2024-04-06) Codesize: 249 | Colors: Yes | 1v1 capable: No
; ==================================================================================================
; - Antigravity movement based on DustBunny, but with forces calculated based on
;   where we would aim to hit the enemy, rather than where they currently are
; - Aim like DustBunny but with different energy management based only on how
;   many enemies are still alive. Fire more agressively early on and much less
;   agressively in 1v1
; - Quite a bit of code shrinking to make room for Infinity style target tracking
;
; ==================================================================================================
; v0.2.2a (2024-04-11) Codesize: 249 | Colors: Yes | 1v1 capable: No
; ==================================================================================================
; - No functional changes, added credits, version history and commented the code
;
; ==================================================================================================
; v0.2.3 (2024-05-11) Codesize: 245 | Colors: Yes | 1v1 capable: No
; ==================================================================================================
; - Change to int for distance and targetDistance variables
; - Switch to a gunHeat radar lock that doesn't require an if statement
; - Switch from setTurnRight to setTurnLeft
; - Fix the radar bug introduced in v0.2.1 that was added to make room for colours
;
; ==================================================================================================
; v0.2.4 (2024-05-16) Codesize: 249 | Colors: No | 1v1 capable: No
; ==================================================================================================
; - Add some energy management
;
; ==================================================================================================
; v1.0.0 (2024-05-30) Codesize: 249 | Colors: No | 1v1 capable: No
; ==================================================================================================
; - Remove the energy management added in v0.2.4
; - Switch to DustBunny's bullet power and energy management
; - Only fire if getGunTurnRemainingRadians < 18.0 / distance (Checked /after/ setTurnGun)
; - Switch to assembly to squeeze it all in (Saved 13 bytes)

; --------------------------------------------------------------------------------------------------
; TODO
; --------------------------------------------------------------------------------------------------
; - Use the result of normalRelativeAngle in setTurnGunLeftRadians instead of calling
;   getGunTurnRemainingRadians. Should be able to save 3 bytes.
; - Revisit xForce/yForce calculations wrt codesize.
; - Revisit Math.sin(-absBearing + e.getHeadingRadians()) wrt codesize.

; --------------------------------------------------------------------------------------------------
; Tuning Knobs (Find / Replace)
; --------------------------------------------------------------------------------------------------
; WALL_FORCE
; AGRAV_DECAY
; AHEAD_AMOUNT

; AIM_START
; AIM_FACTOR
; AIM_TOLERANCE
; BULLET_POWER
; ENERGY_FACTOR
; RADAR_LOCK_THRESHOLD

; --------------------------------------------------------------------------------------------------
; Constants (Find / Replace)
; --------------------------------------------------------------------------------------------------
; BATTLEFIELD_SIZE

; --------------------------------------------------------------------------------------------------
; Globals
; --------------------------------------------------------------------------------------------------
.field static targetName Ljava/lang/String;
.field static targetDistance D
.field static xForce D
.field static yForce D

; --------------------------------------------------------------------------------------------------
; Quantum()
; --------------------------------------------------------------------------------------------------
.method public <init> : ()V
    .code stack 1 locals 1
        aload_0
        invokespecial Method robocode/AdvancedRobot <init> ()V
        return
    .end code
.end method

; --------------------------------------------------------------------------------------------------
; run()
; --------------------------------------------------------------------------------------------------
.method public run : ()V
    .code stack 5 locals 1
    ; ----------------------------------------------------------------------------------------------
    ; setTurnRadarRight(targetDistance = Double.POSITIVE_INFINITY)
    ; ----------------------------------------------------------------------------------------------
        aload_0
        ldc2_w +Infinity
        dup2
        putstatic Field d414/nano/Quantum targetDistance D
        invokevirtual Method d414/nano/Quantum setTurnRadarRight (D)V

        return
    .end code
.end method

; --------------------------------------------------------------------------------------------------
; onRobotDeath(RobotDeathEvent)
; --------------------------------------------------------------------------------------------------
.method public onRobotDeath : (Lrobocode/RobotDeathEvent;)V
    .code stack 2 locals 2
    ; ----------------------------------------------------------------------------------------------
    ; targetDistance = Double.POSITIVE_INFINITY
    ; ----------------------------------------------------------------------------------------------
        ldc2_w +Infinity
        putstatic Field d414/nano/Quantum targetDistance D
        return
    .end code
.end method

; --------------------------------------------------------------------------------------------------
; onScannedRobot(ScannedRobotEvent)
; --------------------------------------------------------------------------------------------------
.method public onScannedRobot : (Lrobocode/ScannedRobotEvent;)V
    .code stack 16 locals 5
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : ScannedRobotEvent : e
    ;   r2 :                   : (Uninitialised)
    ;   r3 :                   : (Uninitialised)
    ; Stack:
    ;   Empty
    ; ----------------------------------------------------------------------------------------------
        aload_1
        aload_0
        dup2
    ; ----------------------------------------------------------------------------------------------
    ; setAdjustGunForRobotTurn(true)
    ; ----------------------------------------------------------------------------------------------
        iconst_1
        invokevirtual Method d414/nano/Quantum setAdjustGunForRobotTurn (Z)V
        invokevirtual Method robocode/ScannedRobotEvent getHeadingRadians ()D
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : ScannedRobotEvent : e
    ;   r2 :                   : (Uninitialised)
    ;   r3 :                   : (Uninitialised)
    ; Stack:
    ;   e this e.getHeadingRadians()
    ; ----------------------------------------------------------------------------------------------
        aload_0
        invokevirtual Method d414/nano/Quantum getHeadingRadians ()D
        dup2_x2
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : ScannedRobotEvent : e
    ;   r2 :                   : (Uninitialised)
    ;   r3 :                   : (Uninitialised)
    ; Stack:
    ;   e this getHeadingRadians() e.getHeadingRadians() getHeadingRadians()
    ; ----------------------------------------------------------------------------------------------
        aload_1
        invokevirtual Method robocode/ScannedRobotEvent getBearingRadians ()D
        dadd
        dup2_x2
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : ScannedRobotEvent : e
    ;   r2 :                   : (Uninitialised)
    ;   r3 :                   : (Uninitialised)
    ; Stack:
    ;   e this getHeadingRadians() absBearing e.getHeadingRadians() absBearing
    ; ----------------------------------------------------------------------------------------------
        dsub
        invokestatic Method java/lang/Math sin (D)D
        aload_1
        invokevirtual Method robocode/ScannedRobotEvent getVelocity ()D
        dmul
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : ScannedRobotEvent : e
    ;   r2 :                   : (Uninitialised)
    ;   r3 :                   : (Uninitialised)
    ; Stack:
    ;   e this getHeadingRadians() absBearing latVel
    ; ----------------------------------------------------------------------------------------------
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: AIM_START
    ; ----------------------------------------------------------------------------------------------
        ldc2_w +10.0
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: AIM_FACTOR
    ; ----------------------------------------------------------------------------------------------
        ldc2_w +1.008
        aload_1
        invokevirtual Method robocode/ScannedRobotEvent getDistance ()D
        dup2
        dstore_1
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 :                   : (Uninitialised)
    ; Stack:
    ;   e this getHeadingRadians() absBearing latVel AIM_START AIM_FACTOR e.getDistance()
    ; ----------------------------------------------------------------------------------------------
        invokestatic Method java/lang/Math pow (DD)D
        dadd
        ddiv
        dadd
        dstore_3
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 : double            : aimAngle
    ; Stack:
    ;   e this getHeadingRadians()
    ; ----------------------------------------------------------------------------------------------
        aload_0
        invokevirtual Method d414/nano/Quantum getX ()D
        getstatic Field d414/nano/Quantum xForce D
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: AGRAV_DECAY
    ; ----------------------------------------------------------------------------------------------
        ldc2_w +0.9
        dmul
        dload_3
        invokestatic Method java/lang/Math sin (D)D
        dload_1
        ddiv
        dsub
        dup2_x2
        putstatic Field d414/nano/Quantum xForce D
        invokestatic Method d414/nano/Quantum calcWallForce (D)D
        dadd
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 : double            : aimAngle
    ; Stack:
    ;   e this getHeadingRadians() ( xForce' + calcWallForce(getX()) )
    ; ----------------------------------------------------------------------------------------------
        aload_0
        invokevirtual Method d414/nano/Quantum getY ()D
        getstatic Field d414/nano/Quantum yForce D
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: AGRAV_DECAY
    ; ----------------------------------------------------------------------------------------------
        ldc2_w +0.9
        dmul
        dload_3
        invokestatic Method java/lang/Math cos (D)D
        dload_1
        ddiv
        dsub
        dup2_x2
        putstatic Field d414/nano/Quantum yForce D
        invokestatic Method d414/nano/Quantum calcWallForce (D)D
        dadd
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 : double            : aimAngle
    ; Stack:
    ;   e this getHeadingRadians() ( xForce' + calcWallForce(getX()) ) ( yForce' + calcWallForce(getY()) )
    ; ----------------------------------------------------------------------------------------------
        invokestatic Method java/lang/Math atan2 (DD)D
        dsub
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 : double            : aimAngle
    ; Stack:
    ;   e this ( turnAngle - getHeadingRadians() )
    ; ----------------------------------------------------------------------------------------------
        invokestatic Method robocode/util/Utils normalRelativeAngle (D)D
        invokevirtual Method d414/nano/Quantum setTurnLeftRadians (D)V
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 : double            : aimAngle
    ; Stack:
    ;   e
    ; ----------------------------------------------------------------------------------------------
        aload_0
        aload_0
        dup2_x1
        dup2_x1
        invokevirtual Method d414/nano/Quantum getTurnRemaining ()D
        invokestatic Method java/lang/Math abs (D)D
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: AHEAD_AMOUNT
    ; ----------------------------------------------------------------------------------------------
        ldc2_w +120.0
        dsub
        invokevirtual Method d414/nano/Quantum setBack (D)V
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 : double            : aimAngle
    ; Stack:
    ;   this this this this e
    ; ----------------------------------------------------------------------------------------------
        invokevirtual Method robocode/ScannedRobotEvent getName ()Ljava/lang/String;
        dup
        getstatic Field d414/nano/Quantum targetName Ljava/lang/String;
        if_acmpeq L_TARGET
        dload_1
        getstatic Field d414/nano/Quantum targetDistance D
        dcmpg
        ifge L_NOT_TARGET

L_TARGET:
        .stack full
            locals Object d414/nano/Quantum Double Double
            stack Object d414/nano/Quantum Object d414/nano/Quantum Object d414/nano/Quantum Object d414/nano/Quantum Object java/lang/String
        .end stack

    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 : double            : aimAngle
    ; Stack:
    ;   this this this this e.getName()
    ; ----------------------------------------------------------------------------------------------
        putstatic Field d414/nano/Quantum targetName Ljava/lang/String;
        dload_1
        putstatic Field d414/nano/Quantum targetDistance D

    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 : double            : aimAngle
    ; Stack:
    ;   this this this this
    ; ----------------------------------------------------------------------------------------------
        invokevirtual Method d414/nano/Quantum getGunHeat ()D
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: RADAR_LOCK_THRESHOLD
    ; ----------------------------------------------------------------------------------------------
        dconst_1
        dsub
        aload_0
        invokevirtual Method d414/nano/Quantum getRadarTurnRemaining ()D
        dmul
        invokevirtual Method d414/nano/Quantum setTurnRadarRight (D)V
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 : double            : aimAngle
    ; Stack:
    ;   this this
    ; ----------------------------------------------------------------------------------------------
        invokevirtual Method d414/nano/Quantum getGunHeadingRadians ()D
        dload_3
        dsub
        invokestatic Method robocode/util/Utils normalRelativeAngle (D)D
        invokevirtual Method d414/nano/Quantum setTurnGunLeftRadians (D)V
    ; ----------------------------------------------------------------------------------------------
    ; Locals:
    ;   r0 : Quantum           : this
    ;   r1 : double            : e.getDistance()
    ;   r2 : double_2nd        : e.getDistance()
    ;   r3 : double            : aimAngle
    ; Stack:
    ;   Empty
    ; ----------------------------------------------------------------------------------------------
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: AIM_TOLERANCE
    ; ----------------------------------------------------------------------------------------------
        ldc2_w +18.0
        dload_1
        ddiv
        aload_0
        invokevirtual Method d414/nano/Quantum getGunTurnRemainingRadians ()D
        invokestatic Method java/lang/Math abs (D)D
        dcmpl
        ifle L_DONT_FIRE
        aload_0
        aload_0
        invokevirtual Method d414/nano/Quantum getEnergy ()D
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: ENERGY_FACTOR
    ; ----------------------------------------------------------------------------------------------
        ldc2_w +7.0
        ddiv
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: BULLET_POWER
    ; ----------------------------------------------------------------------------------------------
        ldc2_w +2.49999
        invokestatic Method java/lang/Math min (DD)D

        invokevirtual Method d414/nano/Quantum setFire (D)V

L_DONT_FIRE:
        .stack full
            locals Object d414/nano/Quantum Double Double
            stack
        .end stack
        return

L_NOT_TARGET:
        .stack full
            locals Object d414/nano/Quantum Double Double
            stack Object d414/nano/Quantum Object d414/nano/Quantum Object d414/nano/Quantum Object d414/nano/Quantum Object java/lang/String
        .end stack
        return
    .end code
.end method

; --------------------------------------------------------------------------------------------------
; calcWallForce(double)
; --------------------------------------------------------------------------------------------------
.method public static calcWallForce : (D)D
    .code stack 8 locals 2
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: WALL_FORCE
    ; ----------------------------------------------------------------------------------------------
        dconst_1
        dload_0
        ddiv
    ; ----------------------------------------------------------------------------------------------
    ; Tuning knob: WALL_FORCE
    ; ----------------------------------------------------------------------------------------------
        dconst_1
    ; ----------------------------------------------------------------------------------------------
    ; Constant: BATTLEFIELD_SIZE
    ; ----------------------------------------------------------------------------------------------
        ldc2_w +1000.0
        dload_0
        dsub
        ddiv
        dsub
        dreturn
    .end code
.end method

.end class
