package jeremyreeder.collective;

import java.util.*; import java.lang.*; import java.awt.*;
import robocode.*; import robocode.util.*;

public class Crusader extends CollectiveRobot { /*
	A robot by Jeremy Reeder that charges like Bully but
	communicates data about robot and bullet locations
	like Prophet. This robot makes no effort to dodge
	bullets. It is suitable for 1v1 battles or for team
	play with other CollectiveRobots.
*/	protected int directionToggle = 1;
	protected double getOptimalFirePower(Bogey target) { // balance probability of hitting with benefit of hitting
		return Rules.MAX_BULLET_POWER * 8 / (getTime() - target.getInitialTime());
	}
	protected boolean isTimeToFight = true;
	public void run() {
		setTurnRateRadians(Rules.MAX_TURN_RATE_RADIANS);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		while (true) {
			if (isTimeToFight) fight(); else pray();
			execute();
		}
	}
	protected void fight() {
		refreshData(); // reprioritize enemies, etc.
		// target the enemy
			Bogey target = aquireTarget();
			if (target == null) { // if no hostile Bogeys, search for more
				final double velocity = getVelocity();
				final double absoluteSpeed = Math.abs(velocity);
				setVelocityRate( // slow down if necessary to avoid wall damage
					nonZeroSign(velocity) * Math.min(absoluteSpeed, 1.999)
				);
				searchForBogeys();
			} else {
				setTurnRateRadians(0);
				scanTargetArea(target);
				final double optimalFirePower = getOptimalFirePower(target);
				final boolean isInMySights = aimAtTarget(target, optimalFirePower);
				if (isInMySights)
					setFire(optimalFirePower);
			}
			if (target != null && target.isHostile()) { // charge target
				final double velocity = getVelocity();
				final double bearingToward = target.getBearingRadians();
				final double bearingAway = Utils.normalRelativeAngle(bearingToward + Math.PI);
				double acceleration, turnRateDivisor;
				acceleration = Rules.ACCELERATION; // approach target quickly
				turnRateDivisor = 4.5;
				if (Math.abs(bearingToward) < Math.abs(bearingAway)) {
					setTurnRateRadians(bearingToward / turnRateDivisor); // turn toward target
					setVelocityRate(getVelocity() + acceleration); // accelerate forward
				} else {
					setTurnRateRadians(bearingAway / turnRateDivisor); // turn away from target
					setVelocityRate(getVelocity() - acceleration); // accelerate backward
				}
			}
	}
	protected void pray() {
		final double east = Math.PI / 2;
		setVelocityRate(getVelocity() / 2); // come to a gradual stop
		setTurnRateRadians( // gradually face east
			Utils.normalRelativeAngle(east - getHeadingRadians()) / 2
		);
		setGunRotationRateRadians( // gradually point east
			Utils.normalRelativeAngle(east - getGunHeadingRadians()) / 2
		);
		setRadarRotationRateRadians( // gradually look east
			Utils.normalRelativeAngle(east - getRadarHeadingRadians()) / 2
		);
	}
	public void onWin(WinEvent e) { isTimeToFight = false; }
	public void onHitWall(HitWallEvent e) { directionToggle = -directionToggle; }
	public void onHitRobot(HitRobotEvent e) {
		super.onHitRobot(e);
		directionToggle = -directionToggle;
	}
}

