package Queens_teamrobot;
import robocode.*;
import java.awt.Color;

/**
 * UltraRazor
 */
public class UltraRazor extends Robot
{
	//this is used to hold coordinate data in some parts of the code
	private class Vec2
	{
		double x,y;
		
		Vec2()
		{
			x=0;
			y=0;
		}	
		Vec2(int i,int j)
		{
			x = i;
			y = j;
		}
	}
	
	int tankDirection = 1;//the direction of the tank
	String targetName = "";//the name of our current enemy
	
	String targetedByName = "";//the name of who we think is targeting us
	double hitByCount = 0;//the number of times they have hit us
	
	int timer = 0;//timer for oscillator
	int radarTurnCount = 0;//the number of times the radar has beeen turned
	int missedCount = 0;//the number of times we have missed our current target
	
	double battleFieldWidth;//width
	double battleFieldHeight;//height
	
	public void run() {

		//setColors(Color.gray,Color.gray,Color.orange);
		setColors(Color.white,Color.white,Color.orange);

		//make sure the radar and turret can turn freely
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		
		//get the size of the world
		battleFieldWidth = getBattleFieldWidth();
		battleFieldHeight = getBattleFieldHeight();
		
	while(true) 
		{
			//try to find a target
			turnRadarRight(360);
			
			//if we turn the radar around more than twice and don't find a target
			//then look for another			
			radarTurnCount++;
			if(radarTurnCount >= 2)
			{
				targetName = "";
				radarTurnCount = 0;
				
				//move towards the centre of the world, hopefully there will be a target near here
				double centreBearing = headingToBearing(absoluteHeading(getX(),getY(),battleFieldWidth/2.0,battleFieldHeight/2.0));
				targetTankBearing(centreBearing);
				ahead(100);				
			}		
			
			if(missedCount > 4 && getOthers() > 1)
			{
				targetName = "";
				missedCount = 0;
			}				
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) 
	{
		//if we don't have a target then the first robot we see is it
		//or if there is a robot very close the choose it
		if(targetName.equals("") || e.getDistance() < 150)
		{
			if(e.getDistance() < 400 || getOthers() == 1)
			{
				targetName = e.getName();
			}
		}
		
		//what to do when we find our target
		if(e.getName().equals(targetName))
		{
			//if target found then reset the radarTurnCount
			radarTurnCount = 0;
			
			//if the target is disabled and close or the last robot standing then ram it
			if(e.getEnergy() == 0 && (e.getDistance() < 200 || getOthers() == 1))
			{
				//move in to ram cautiously as stray bullets may give them some energy back and they could shoot at us
				if(e.getDistance() > 200)
				{
					targetTankBearing(e.getBearing() + (Math.random()*10+1 > 5 ? 22.5 : -22.5));
					ahead(100);
				}
				//if close enough then just move in and ram
				else
				{
					targetTankBearing(e.getBearing());
					ahead(e.getDistance() + 100);
				}
			}
			else
			{
				//if they are close or stationary then shoot straight at them
				if(e.getVelocity() == 0 || e.getDistance() < 25)
				{
					targetGunBearing(e.getBearing());
					fire(3);	
				}
				else//otherwise use the linear targeting
				{
					targetLinear(e);
				}
				
				//the movement code for when were trying the avoid an enemy				
				double antiWallBearing = headingToBearing(absoluteHeading(getX(),getY(),battleFieldWidth/2.0,battleFieldHeight/2.0));
				double perpendicularBearing = e.getBearing() + 90;
				
				double finalBearing = 0;
				
				//what to do if neat the wall
				if(nearWall(getX(),getY(),20))
				{
					//move away from the wall
					finalBearing = antiWallBearing + ((Math.random()*10+1) > 5 ? 45 : -45);
					timer = 0;
					tankDirection = 1;
				}
				else
				{
					//otherwise move perpendicular the our enemy
					finalBearing = perpendicularBearing;//(antiWallBearing + perpendicularBearing)/2.0;
				}
					
				//move the in right direction
				turnRight(finalBearing);				
				ahead(100 * tankDirection);
				
				if(timer >= 2)
				{
					tankDirection *= -1;
					timer = 0;//(int)Math.random()*3+1;
				}
				else
				{
					timer++;
				}
			}							
		}
	}
	
	public void onHitWall(HitWallEvent e)
	{
		//if your in the corner then get out of it
		if(inCorner(getX(),getY(),200))
		{
			double antiCornerBearing = headingToBearing(absoluteHeading(getX(),getY(),battleFieldWidth/2.0,battleFieldHeight/2.0));
			targetTankBearing(antiCornerBearing);
			tankDirection = 1;
			timer = 0;
			ahead(150);			
		}
		//if not in a corner the just reverse out of the wall
		else
		{
			tankDirection *= -1;
			ahead(100 * tankDirection);
			timer = 0;
		}
	}

	public void onRobotDeath(RobotDeathEvent e)
	{	//if your target is destroyed then find another
		if(e.getName().equals(targetName))
		{
			targetName = "";
		}
	}
	
	public void onHitRobot(HitRobotEvent e)
	{
		//make the robot you hit, your target
		targetName = e.getName();
		targetGunBearing(e.getBearing());
		fire(3);//try to kill them ASAP
		//while moving away to their side
		targetTankBearing(e.getBearing() + 90);
		ahead(100);
	}


	public void onHitByBullet(HitByBulletEvent e) 
	{
		//this function coun't the number of times you have been hit by a certain robot
		//if its more than 2 times in a row then it assumes that its targeting you so you should
		//make it your target
		if(e.getName().equals(targetedByName))
		{
			hitByCount++;			
		}
		else
		{
			targetedByName = e.getName();
			hitByCount = 0;
		}
		
		if(hitByCount >= 1)
		{
			targetName = targetedByName;
		}
	}
	
	public void onBulletMissed(BulletMissedEvent e)
	{
		//just keeps count of how well the aiming is going, might want to change target
		//if its missing too much
		missedCount++;
		
		if(missedCount >= 3)
		{
			if(getOthers() > 1)
			{
				targetName = "";
				missedCount = 1;
			}
		}
	}
	
	
	public void onBulletHit(BulletHitEvent e)
	{	
		//reset the missed count if we hit the enemy
		if(e.getName().equals(targetName))
		{
			missedCount = 0;
		}	
	};
	
	public void onWin(WinEvent e)
	{
		//targetGunBearing(headingToBearing(0));
		
		//shoot the gun around a bit :)
		while(true)
		{			
			turnGunRight(10);
			fire(0.001);
			turnGunLeft(20);
		}
	}
	
	/*
	Movement Utilities
	*/
	//turns the gun to a bearing
	public void targetGunBearing(double bearing)
	{
		double gunBearing = headingToBearing(getGunHeading());//the current bearing of the gun
		double delta = gunBearing - bearing; //the angle you need to turn
		
		//make sure the tank turns the shortest angle possible
		if(delta > 180)
		{
			turnGunRight(360 - delta);
		}
		else if(delta < -180)
		{
			turnGunLeft(360 - Math.abs(delta));
		}
		else
		{	
			turnGunLeft(delta);
		}		
	}
	
	//turns the tank to face a bearing
	public void targetTankBearing(double bearing)
	{
		turnRight(bearing);		
	}
	
	/*
		Targeting
	*/
	public void targetLinear(ScannedRobotEvent e)
	{
		//the current position of my tank
		Vec2 myPos = new Vec2();
		myPos.x = getX();
		myPos.y = getY();

		//The current position of the enemy tank
		Vec2 startPos = new Vec2();
		startPos.x = myPos.x + Math.sin(Math.toRadians(bearingToHeading(e.getBearing())))*e.getDistance();
		startPos.y = myPos.y + Math.cos(Math.toRadians(bearingToHeading(e.getBearing())))*e.getDistance();
		
		System.out.println("My Pos " + myPos.x + " " + myPos.y);
		//System.out.println("En Pos " + startPos.x + " " + startPos.y);
		
		//the velocity of the bullet dependant on some factor
		double bulletVelocity = getBulletVelocity(getBulletPower(e.getDistance()));
		
		//the initial time to go from you to their current position
		double oldTime,newTime;
		newTime = (double)(e.getDistance()/bulletVelocity);
		oldTime = 0.0;
		
		//get information on the enemy tank
		int iterationCount = 0;
		double enemyHeading = Math.toRadians(e.getHeading());
		double enemyVelocity = e.getVelocity();
		
		Vec2 futurePos = new Vec2();
		Vec2 toFuturePos = new Vec2();
		
		boolean done = false;
		
		//keep iterating until the times converge or you do too many iterations, don't want to miss a turn
		while(Math.abs(oldTime - newTime) > 0.0001 && iterationCount < 25 && done == false)
		{
			oldTime = newTime;
			
			//get the current projection of where they will be at time - old time
			futurePos.x = startPos.x + Math.sin(enemyHeading)*enemyVelocity*oldTime;
			futurePos.y = startPos.y + Math.cos(enemyHeading)*enemyVelocity*oldTime;
						
			//make sure that you don't aim outside the battlefield, as can happen near the corners and edges
			if(futurePos.x > battleFieldWidth)
			{
				futurePos.x = battleFieldWidth;
				done = true;				
			} 
			if(futurePos.x < 0)
			{
				futurePos.x = 0;
				done = true;
			} 
		
			if(futurePos.y > battleFieldHeight)
			{
				futurePos.y = battleFieldHeight;
				done = true;
			} 
			if(futurePos.y < 0)
			{
				futurePos.y = 0;
				done = true;
			}
			
			//get the distance and hence new time
			double deltaX = futurePos.x - myPos.x;
			double deltaY = futurePos.y - myPos.y;
			
			newTime = Math.sqrt(deltaX*deltaX + deltaY*deltaY)/bulletVelocity;
			iterationCount++;						
		}

		//System.out.println("Fu Pos " + futurePos.x + " " + futurePos.y + "\n");
		
		//aim at where you think they will be
		double headingToFuturePos = absoluteHeading(myPos.x,myPos.y,futurePos.x,futurePos.y);
						
		//aim the gun at them and if the gun heat is zero then shoot
		double targetBearing = headingToBearing(headingToFuturePos);
		targetGunBearing(targetBearing);
		if(getGunHeat() == 0)
		{
			fire(getBulletPower(e.getDistance()));
		}

	}
	
	/*
	Utilities
	*/
	
	//converts from bearing to heading angles
	public double bearingToHeading(double bearing)
	{
		double heading = getHeading() + bearing;
		
		while(heading >= 360){heading -= 360;}	
		while(heading < 0){heading += 360;}
			
		return heading;
	}
	
	//converts from heading to bearing angles
	public double headingToBearing(double heading)
	{
		//make in the range 0 - 359.999...
		while(heading >= 360){heading -= 360;}	
		while(heading < 0){heading += 360;}		
			
		double bearing = heading - getHeading();
		
		if(bearing <= 180)
			return bearing;
		else
			return (-1 * (360 - bearing));
	}
	
	//returns an absolute heading between any two cartesian coodinates in robocode form
	public double absoluteHeading(double x1,double y1,double x2,double y2)
	{
		double dx = x2 - x1;
		double dy = y2 - y1;
		double hyp = Math.sqrt((dx*dx) + (dy*dy));	
		double arcSin = Math.toDegrees(Math.asin(dx/hyp));
		double heading = 0;
		
		if(dx == 0)
		{
			if(dy < 0)
				heading = 180;
			else
				heading = 0;
		}
		else if(dy == 0)
		{
			if(dx < 0)
				heading = 270;
			else
				heading = 90;
		}		
		else if(dx > 0 && dy > 0)
			heading = arcSin;		
		else if(dx > 0 && dy < 0)
			heading = 180 - arcSin;
		else if(dx < 0 && dy < 0)
			heading = 180 - arcSin;
		else if(dx < 0 && dy > 0)
			heading = 360 + arcSin;
		
		return heading;		
	}
	
	//used to vary the bullet power with some factor
	//distance can be passed to it to use that
	public double getBulletPower(double distance)
	{
		double power = 500.0/distance;
		
		if(power < 0.1)
		{
			power = 0.1;
		}
		if(power > 3)
		{
			power = 3.0;
		}
		
		return power;
	}
	
	//the velocity of the bullet proportional to distance
	//equation from robocode documentation
	public double getBulletVelocity(double power)
	{
		return 20.0 - 3.0 * power;	
	}	
	
	//lets the robot know if its within a certain distance of the wall so it can take action
	public boolean nearWall(double xPos,double yPos,double bufferDistance)
	{
		return (xPos <= bufferDistance || xPos >= (battleFieldWidth - bufferDistance) || yPos <= bufferDistance || yPos >= (battleFieldHeight - bufferDistance));		
	}
	
	//returns true if your within cornerRadius of the corner
	public boolean inCorner(double xPos,double yPos,double cornerRadius)
	{
		double c1 = Math.sqrt(xPos*xPos + yPos*yPos);
		double c2 = Math.sqrt((xPos-battleFieldWidth)*(xPos-battleFieldWidth) + yPos*yPos);
		double c3 = Math.sqrt((xPos-battleFieldWidth)*(xPos-battleFieldWidth) + (yPos-battleFieldHeight)*(yPos-battleFieldHeight));
		double c4 = Math.sqrt(xPos*xPos + (yPos-battleFieldHeight)*(yPos-battleFieldHeight));
		
		return (c1 <= cornerRadius || c2 <= cornerRadius || c3 <= cornerRadius || c4 <= cornerRadius);
	}
}											