package suh.nano;

import robocode.*;
import robocode.util.Utils;

public class TargetL extends AdvancedRobot {
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    execute();
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	double bearing;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((bearing = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Targeting
	setTurnGunRightRadians(Utils.normalRelativeAngle((bearing + Math.asin(e.getVelocity() * Math.sin(e.getHeadingRadians() - bearing) / Rules.getBulletSpeed(3))) - getGunHeadingRadians()));
	setFire(3);
    }
}
