package donjezza;
import robocode.*;
import robocode.util.*;

public class Muncho extends Robot
{
	static int stationary = 0;
	
	public void run()
	{
		while (true)
		{
			if(stationary>7) move();
			turnRadarRight(45);
			stationary++;
		}
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		turnGunLeft(normTurn(getGunHeading() - (getHeading() + e.getBearing())));
		fire(3*(getEnergy()/100));
		stationary++;
	}

	public void onHitByBullet(HitByBulletEvent e)
	{
		turnRight(normTurn(e.getBearing()-90));
		move();
	}

	public void onHitWall(HitWallEvent e)
	{
		double bear = e.getBearing();
		if(bear==0){turnRight(90);return;}
		double sign = bear/Math.abs(bear);
		double diff = getGunHeading()-getHeading();
		turnLeft(sign*(90-Math.abs(bear)));
		turnGunRight(-sign*90-diff);
		move();
	}

	public void onHitRobot(HitRobotEvent e)
	{
		turnRadarRight(normTurn(getRadarHeading()-(getHeading() + e.getBearing())));
	}

	public void move()
	{
		ahead(Math.round((2*Math.random()-1)*60)*8);
		stationary = 0;
	}

	public double normTurn(double bear)
	{
		return Math.toDegrees(Utils.normalRelativeAngle(Math.toRadians(bear)));
	}
}