package sgp;
import robocode.*;
import java.util.*;
import java.lang.String;

/**
 * TargetTable - a class by Simon Parker
 */

public class TargetTable extends Object implements java.io.Serializable
{
	//We'll have a hash table that stores indexes references by robot names
	// and a vector that stores the target info at the referenced indexes.
	Hashtable targetIndexTable = new Hashtable();
	Vector targetVector = new Vector();
	int nextTargetIndex = 0;

	private TeamTarget leader = null;

	public void update(RobotSnapshot robotSnapshot)
	{
		if (robotSnapshot.name == Environment.getRobot().getName()) return;

		TeamTarget target = getByName(robotSnapshot.name);
		target.set(robotSnapshot);
	}

	public void reset()
	{
		for (int i = 0; i < targetVector.size(); i++)
		{
			TeamTarget comparedTarget = (TeamTarget)targetVector.elementAt(i);
			comparedTarget.reset();
		}
	}

	public int getNum()
	{
		return targetVector.size();
	}

	public TeamTarget getAt(int index)
	{
		return (TeamTarget)targetVector.elementAt(index);
	}

	public TeamTarget getByName(String targetName)
	{
		TeamTarget target;
		Integer targetIndex = (Integer)targetIndexTable.get(targetName);
		if (targetIndex == null)
		{
			target = new TeamTarget(targetName);
			targetIndexTable.put(targetName, new Integer(nextTargetIndex));
			targetVector.add(target);
			nextTargetIndex++;
		}
		else
		{
			target = (TeamTarget)targetVector.elementAt(targetIndex.intValue());
		}

		return target;
	}

	private TeamTarget getMostHealthyRobot()
	{
		TeamTarget healthyTarget = null;

		for (int i = 0; i < targetVector.size(); i++)
		{
			TeamTarget comparedTarget = (TeamTarget)targetVector.elementAt(i);

			if (!comparedTarget.isAlive) continue;
			if (!comparedTarget.isEnemy()) continue;
			if (comparedTarget.lastTimeScanned < 0) continue;

			if (healthyTarget == null)
			{
				//have not found the first alive target yet
				healthyTarget = comparedTarget;
			}
			else
			{
				//compare with current oldest update
				if (comparedTarget.energy > healthyTarget.energy)
				{
					healthyTarget = comparedTarget;
				}
			}
		}

		return healthyTarget;
	}

	public TeamTarget getClosestEnemy(Coordinate robotPosition)
	{
		TeamTarget target = null;

		for (int i = 0; i < targetVector.size(); i++)
		{
			TeamTarget comparedTarget = (TeamTarget)targetVector.elementAt(i);

			if (!comparedTarget.isAlive) continue;
			if (!comparedTarget.isEnemy()) continue;
			if (comparedTarget.lastTimeScanned < 0) continue;

			if (target == null)
			{
				//have not found the first alive target yet
				target = comparedTarget;
			}
			else
			{
				//compare with current
				if (comparedTarget.position.distanceFrom(robotPosition) < target.position.distanceFrom(robotPosition))
				{
					target = comparedTarget;
				}
			}
		}

		return target;
	}

	public TeamTarget getClosestTarget(Coordinate robotPosition)
	{
		TeamTarget target = null;

		for (int i = 0; i < targetVector.size(); i++)
		{
			TeamTarget comparedTarget = (TeamTarget)targetVector.elementAt(i);

			if (!comparedTarget.isAlive) continue;
			if (comparedTarget.lastTimeScanned < 0) continue;

			if (target == null)
			{
				//have not found the first alive target yet
				target = comparedTarget;
			}
			else
			{
				//compare with current
				if (comparedTarget.position.distanceFrom(robotPosition) < target.position.distanceFrom(robotPosition))
				{
					target = comparedTarget;
				}
			}
		}

		return target;
	}


	public TeamTarget getClosestBearingTeammate(Coordinate robotPosition, Coordinate targetPosition)
	{
		TeamTarget target = null;
		double robotBearingToTarget = robotPosition.headingTo(targetPosition);
		double comparedBearingDifference = 720;
		AdvancedRobot robot = Environment.getRobot();

		for (int i = 0; i < targetVector.size(); i++)
		{
			TeamTarget comparedTarget = (TeamTarget)targetVector.elementAt(i);

			if (!comparedTarget.isAlive) continue; //dead
			if (comparedTarget.isEnemy()) continue; //enemy
			if (comparedTarget.lastTimeScanned < 0) continue; //not scanned yet

			if (target == null)
			{
				//have not found the first alive target yet
				target = comparedTarget;
				double teammateBearingToTarget = comparedTarget.getEstimatedPosition(robot.getTime()).headingTo(targetPosition);
				comparedBearingDifference = Math.abs(Strategy.normalRelativeAngle(teammateBearingToTarget - robotBearingToTarget));
			}
			else
			{
				//compare with current
				double teammateBearingToTarget = comparedTarget.getEstimatedPosition(robot.getTime()).headingTo(targetPosition);
				double bearingDifference = Math.abs(Strategy.normalRelativeAngle(teammateBearingToTarget - robotBearingToTarget));
				if (comparedBearingDifference > bearingDifference)
				{
					target = comparedTarget;
					comparedBearingDifference = bearingDifference;
				}
			}
		}

		return target;
	}

	public TeamTarget getEnemyLeader()
	{
		TeamTarget target = null;

		for (int i = 0; i < targetVector.size(); i++)
		{
			TeamTarget comparedTarget = (TeamTarget)targetVector.elementAt(i);

			if (!comparedTarget.isAlive) continue;
			if (!comparedTarget.isEnemy()) continue;
			if (comparedTarget.lastTimeScanned < 0) continue;
			if (comparedTarget.isLeader())
			{
				target = comparedTarget;
				break;
			}
		}

		return target;
	}



	public TeamTarget getMostOutDatedTarget()
	{
		TeamTarget oldTarget = null;

		for (int i = 0; i < targetVector.size(); i++)
		{
			TeamTarget comparedTarget = (TeamTarget)targetVector.elementAt(i);

			if (!comparedTarget.isAlive) continue;
			if (comparedTarget.lastTimeScanned < 0) continue;

			if (oldTarget == null)
			{
				//have not found the first alive target yet
				oldTarget = comparedTarget;
			}
			else
			{
				//compare with current oldest update
				if (comparedTarget.lastTimeScanned < oldTarget.lastTimeScanned)
				{
					oldTarget = comparedTarget;
				}
			}
		}

		return oldTarget;
	}

	public void setRobotDead(String targetName)
	{
		TeamTarget target = getByName(targetName);
		target.isAlive = false;
		Environment.getRobot().out.println("DEAD " + targetName);
	}

	public int getNumAlive()
	{
		int aliveCount = 0;

		for (int i = 0; i < getNum(); i++)
		{
			TeamTarget target1 = (TeamTarget)targetVector.elementAt(i);
			if (target1.isAlive) aliveCount++;
		}

		return aliveCount;
	}

}