package pi.gun;

import java.awt.geom.Point2D;



public class EnemyData
{
	public final static double samplePeriod = 4;//8
	public final static int window = 20;//10
	public final static int historySize = 500;
	public double X;
	public double Y;
	public double bearing;
	public double distance;
	public double next_sample_time;
	public double energy;
	public double previousHeading;
	public double previousX;
	public double previousY;
	public int PC = 0;
	public float[] dX;
	public float[] dY;

	public EnemyData()
	{
		dX = new float[historySize];
		dY = new float[historySize];
		init();
	}

	public void init()
	{
		this.next_sample_time = 0;
	}

	public void addMove(double eX, double eY)
	{
		if (next_sample_time > (2*samplePeriod))
		{
			double sampledHeading = Math.atan2((eX - this.previousX), (eY - this.previousY));
			double dist = Point2D.distance(eX, eY, this.previousX, this.previousY);
			if (dist == 0.0)
				sampledHeading = previousHeading;
			double ang = angle_180(sampledHeading - this.previousHeading);
			int pcounter = PC % historySize;
			dX[pcounter] = (float)(dist * Math.sin(ang));
			dY[pcounter] = (float)(dist * Math.cos(ang));
			if (dist != 0.0)
				this.previousHeading = sampledHeading;
			PC++;
			if (PC > 2 * historySize)
				PC -= historySize;
		}
		this.previousX = eX;
		this.previousY = eY;
	}

	public int findPattern(int windowSize, int start)
	{
		int index = PC;
		double error = Double.POSITIVE_INFINITY;

		for (int i = start; i < (Math.min(PC, historySize) - windowSize); i++)
		{
			double thiserror = 0;
			for (int j = 1; j <= windowSize; j++)
			{
				int ind = PC - j;
				thiserror += Math.pow(((windowSize + 3) - j),2) * Point2D.distanceSq(dX[ind % historySize], dY[ind % historySize], dX[(ind - i) % historySize], dY[(ind - i) % historySize]);
			}
			if (thiserror < error)
			{
				error = thiserror;
				index = i;
			}
		}
		return PC - index - 1;
	}
	
	public double predictAngle(double myX, double myY, double bp, double time)
	{
		double bv = 20 - 3 * bp;
		int ip = findPattern(window, (int)(this.distance/(8*bv)));
		double db = (- samplePeriod + next_sample_time - time + 1) * bv;
		double nX = this.previousX;
		double nY = this.previousY;
		double nHeading = this.previousHeading;
		double dE = Point2D.distance(myX, myY, nX, nY);
		double displ;
		do
		{
			db += samplePeriod * bv;
			ip = (ip + 1) % historySize;
			displ = Point2D.distance(0, 0, dX[ip], dY[ip]);
			nHeading += Math.atan2(dX[ip], dY[ip]);
			nX += displ * Math.sin(nHeading);
			nY += displ * Math.cos(nHeading);
			dE = Point2D.distance(myX, myY, nX, nY);
		} while (db < dE);

		displ = displ / samplePeriod;

		do
		{
			db -= bv;
			nX -= displ * Math.sin(nHeading);
			nY -= displ * Math.cos(nHeading);
			dE = Point2D.distance(myX, myY, nX, nY);
		} while (db > dE);
		return Math.atan2((nX - myX), (nY - myY));
	}

	public void updateInfo(double t, double ex, double ey, double ebearing, double edist, double eEnergy)
	{
		this.X = ex;
		this.Y = ey;
		this.bearing = ebearing;
		this.distance = edist;
		this.energy = eEnergy;
		if (t >= next_sample_time)
		{
			next_sample_time += samplePeriod;
			addMove(ex, ey);
		}
	}

public static double angle_180(double ang)
	{
		return Math.atan2(Math.sin(ang), Math.cos(ang));
	}
}
												