package pi.radar;

import java.util.*;
import pi.*;

public class Sweep extends RadarMode
{
double p=Math.PI;
double etat;


public Sweep(MasterBot _monRobot,Vector _informations,double _etat)
	{
	monRobot=_monRobot;	
	informations=_informations;
	etat=_etat;	
	}

public void doRadar()
	{
	if(monRobot.getTime()>8 && informations.size()==1)
		{
		if(etat==1) moveTo(getMax(),p/9);		
		if(etat==-1) moveTo(getMin(),p/9);		
		}	
	else
		{
		if(etat==1) moveTo(getMax(),p/6);		
		if(etat==-1) moveTo(getMin(),p/6);			
		}	
	}						
public void moveTo(double angle,double marge)
	{
	double r=monRobot.getRadarHeadingRadians();
	if(r<angle)
		{
		if(angle-r<p) monRobot.setTurnRadarRightRadians(angle-r+marge);
		else monRobot.setTurnRadarLeftRadians(2*p-angle+r+marge);	
		}
	else
		{
		if(r-angle<p)	monRobot.setTurnRadarLeftRadians(r-angle+marge);
		else			monRobot.setTurnRadarRightRadians(2*p-r+angle+marge);
		}
	}
		
public double getMin()
	{

	Point moi=new Point(monRobot.getX(),monRobot.getY());
	double m=2*p;
	double t=2*p;	
	Vector v=informations;
	for(int i=0;i<v.size();i++)
		{
		t=Point.angle_absolu( moi,((Informations)v.elementAt(i)).position);
		if(t<m) m=t;
		}	
	return m;			
	}		

public double getMax()
	{
	Point moi=new Point(monRobot.getX(),monRobot.getY());
	double m=0;
	double t=0;	
	Vector v=informations;
	for(int i=0;i<v.size();i++)
		{
		t=Point.angle_absolu( moi,((Informations)v.elementAt(i)).position);

		if(t>m) m=t;	
		}	
	return m;			
	}			
}
												