 /**
 *  Utilities for robot.
 *  Some necessary methods in this class.
 */

package timmit;
import java.awt.geom.Point2D;

class Util{
	static final double HALF_PI = Math.PI/2;
	static final double DOUBLE_PI = Math.PI*2;
	static final double QUARTER_PI = Math.PI/4;
		
	/*
	 *	get relative radians, return -Pi -- Pi.
	 */
	static double getRelativeRadians(double r){
		return Math.atan2( Math.sin(r), Math.cos(r) );
	}
	
	/*
	 *	get range between two points.
	 */
	static double getRange(double x1,double y1,double x2,double y2){
		return Point2D.distance( x1, y1, x2, y2 );
	}
	
	/**
	 *	return random number you want,random between min and max.
	 */
	static double getDoubleRandom(double min,double max){
		return Math.random() * (max - min) + min;
	}
	
	/**
	 *	return random rator(direction), -1 or 1.
	 */
	 static int getRandomRator(double separator){
	 	return Math.random()>separator ? 1 : -1;
	 }
	 
	 /**
	  *		debug method, out print inforamtion.
	  */
	  static void out(String s,TimmiT bot){
	  	bot.out.println(s);
	  }
	  static void out(double d,TimmiT bot){
	  	bot.out.println(d);
	  }
	  static void out(int i,TimmiT bot){
	  	bot.out.println(i);
	  }
	  static void out(Exception e,TimmiT bot){
	  	bot.out.println(e.toString());
	  }
}