package paulk;
import robocode.*;
import robocode.util.*;
import java.awt.geom.*;
import java.util.*;

public class MouvementManager{
	static final int nbBins=199;
	static final int nbSegment=2;
	Map gfs,nbAmeliore[];
	List ondes;
	String ancCible="p";
	PaulV3 bot;
	Rectangle2D.Double terrain;

	MouvementManager(PaulV3 r){
		bot=r;
		gfs=new Hashtable();
		nbAmeliore=new Hashtable[nbSegment];
		for (int i=0;i<nbSegment;i++)
			nbAmeliore[i]=new Hashtable();
		ondes=new ArrayList();
		terrain=new Rectangle2D.Double(40,40,r.getBattleFieldWidth()-80,r.getBattleFieldHeight()-80);
	}

	public void nouvBot(PaulV3 r){
		bot=r;
		ondes.clear();
	}

	public void nouvOnde(SonOnde s){
		ondes.add(0,s);
	}

	public void onHitByBullet(HitByBulletEvent e){
		int idOnde=-1;
		double minTemps=100000;
		for (int i=0;i<ondes.size();i++){
			SonOnde s=(SonOnde)ondes.get(i);
			double t=Math.abs(s.tempsRestant());
			if (t<minTemps && Math.abs(e.getPower()-s.getEnergie())<0.1 && s.getNom()==e.getName()){
				idOnde=i;
				minTemps=t;
			}
		}
		if (idOnde==-1) return;
		SonOnde s=(SonOnde)ondes.get(idOnde);
		Point2D.Double ancPos=s.getAncPos(),pos=s.getPos();
		double angle=Math.atan2(bot.getX()-pos.getX(),bot.getY()-pos.getY());
		angle-=Math.atan2(ancPos.getX()-pos.getX(),ancPos.getY()-pos.getY());
		angle=Utils.normalRelativeAngle(angle);
		double dist=pos.distance(bot.getX(),bot.getY()),puiss=e.getPower();
		double tailleAngle=Math.asin(18./dist); // 18==demi-taille
		double bins[][];
		if (gfs.containsKey(s.getNom())){
			bins=(double[][])gfs.get(s.getNom());
		}
		else {
			bins=new double[nbSegment][nbBins];
			for (int i=0;i<nbSegment;i++){
				bins[i][nbBins/2]=0.1;
				nbAmeliore[i].put(s.getNom(),0.1);
			}
			gfs.put(s.getNom(),bins);
		}
		int segment=s.getSegment();
		for (int i=angle2bin(angle-tailleAngle,puiss);i<=angle2bin(angle+tailleAngle,puiss);i++){
			bins[segment][i]++;
		}
		for (int i=0;i<nbBins;i++){
			bins[segment][i]+=1./Math.pow(5+Math.abs(angle2bin(angle,puiss)-i),2.);
		}
		double nb=(Double)nbAmeliore[segment].get(s.getNom());
		nbAmeliore[segment].put(s.getNom(),nb+1+1./Math.pow(5,2.));
		clean();
	}

	public void bouge(ScannedRobotEvent e){
		clean();
		double gauche=0,droite=0;
		SonOnde s=null;
		double minTemps=100000;
		for (int i=0;i<ondes.size();i++){
			SonOnde onde=(SonOnde)ondes.get(i);
			ancCible=onde.getNom();
			double mul=Rules.getBulletDamage(onde.getEnergie())/Math.sqrt(Math.abs(onde.tempsRestant())+1);
			gauche+=danger(onde,-1,e)*mul;
			droite+=danger(onde, 1,e)*mul;
			if (onde.tempsRestant()<minTemps){
				minTemps=onde.tempsRestant();
				s=onde;
			}
		}
		if (s==null) return;
		Point2D.Double pos=new Point2D.Double(bot.getX(),bot.getY());
		double angle=absoluteBearing(s.getPos(),pos);
		if (gauche<droite){
			angle=wallSmoothing(pos,angle-Math.PI/2,-1);
		}
		else {
			angle=wallSmoothing(pos,angle+Math.PI/2,1);
		}
		double depl=Utils.normalRelativeAngle(angle-bot.getHeadingRadians());
		if (Math.abs(depl)>Math.PI/2){
			depl=Utils.normalRelativeAngle(Math.PI+depl);
			bot.setTurnRightRadians(depl);
			bot.setBack(100.);
		}
		else {
			bot.setTurnRightRadians(depl);
			bot.setAhead(100.);
		}
	}

	static int getSegment(ScannedRobotEvent e,AdvancedRobot r){
		double angle=e.getBearingRadians()+r.getHeadingRadians()+Math.PI;
		int sens=Utils.normalRelativeAngle(r.getHeadingRadians()-angle)<0 ? 0 : 1;
		return r.getVelocity()<0 ? 1-sens:sens;
	}

	void clean (){
		for (int i=0;i<ondes.size();i++){
			SonOnde s=(SonOnde)ondes.get(i);
			if (s.passe()){
				ondes.remove(i);
				i--;
			}
		}
	}

	public double danger(SonOnde onde,int direction,ScannedRobotEvent e){
		Point2D.Double pos=predictPosition(onde,direction);
		double angle=Utils.normalRelativeAngle(
			absoluteBearing(onde.getPos(),pos)
			-absoluteBearing(onde.getPos(),onde.getAncPos()));
		int index=angle2bin(angle,onde.getEnergie());
		double bins[][];
		int segment=onde.getSegment();
		if (gfs.containsKey(onde.getNom())){
			bins=(double[][])gfs.get(onde.getNom());
		}
		else {
			bins=new double[nbSegment][nbBins];
			for (int i=0;i<nbSegment;i++){
				bins[i][nbBins/2]=0.1;
				nbAmeliore[i].put(onde.getNom(),0.1);
			}
			gfs.put(onde.getNom(),bins);
		}
		int taille=angle2bin(Math.asin(18./pos.distance(onde.getPos())),onde.getEnergie())-nbBins/2;
		double danger=0;
		for (int i=Math.max(0,index-taille);i<=Math.min(nbBins-1,index+taille);i++){
			danger+=bins[segment][i];
		}
		double nb=(Double)nbAmeliore[segment].get(onde.getNom());
		Point2D.Double maPos=new Point2D.Double(bot.getX(),bot.getY());
		Point2D.Double posEnnemi=projecte(maPos,e.getBearingRadians()+bot.getHeadingRadians(),e.getDistance());
		danger=(danger/nb)/(2*taille)+(posEnnemi.distance(pos) < 100 ? 0.2 : 0);
//		System.out.println(direction+" "+(index-taille)+" "+(index+taille));
//		System.out.println("dist="+pos.distance(onde.getPos())+" taille="+taille+" danger="+danger);
/*		for (int i=0;i<nbBins;i++){
			danger+=bins[i]/Math.pow(Math.abs(i-index)+5,2.);
		}*/
//		System.out.println(direction+" "+danger+" "+index+" "+angle*180/3.14+" "+maxEscapeAngle(onde.getEnergie())*180/3.14);
		return danger;
	}

	public Point2D.Double predictPosition(SonOnde onde, int direction) {
		// Wiki : WaveSurfing Tutorial par Voidious
		Point2D.Double predictedPosition = new Point2D.Double(bot.getX(),bot.getY());
		double predictedVelocity = bot.getVelocity();
		double predictedHeading = bot.getHeadingRadians();
		double maxTurning, moveAngle, moveDir;

		int counter = 0; // number of ticks in the future
		boolean intercepted = false;

		do {    // the rest of these code comments are rozu's
			moveAngle =
			wallSmoothing(predictedPosition, absoluteBearing(onde.getPos(),
				predictedPosition) + (direction * (Math.PI/2)), direction)
				- predictedHeading;
			moveDir = 1;

			if(Math.cos(moveAngle) < 0) {
				moveAngle += Math.PI;
				moveDir = -1;
			}

			moveAngle = Utils.normalRelativeAngle(moveAngle);

			// maxTurning is built in like this, you can't turn more than this in one tick
			maxTurning = Math.PI/720d*(40d - 3d*Math.abs(predictedVelocity));
			predictedHeading = Utils.normalRelativeAngle(predictedHeading
			+ limite(-maxTurning, moveAngle, maxTurning));

			// this one is nice ;). if predictedVelocity and moveDir have
			// different signs you want to breack down
			// otherwise you want to accelerate (look at the factor "2")
			predictedVelocity += 
			(predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
			predictedVelocity = limite(-8, predictedVelocity, 8);

			// calculate the new predicted position
			predictedPosition = projecte(predictedPosition, predictedHeading, 
				predictedVelocity);

			counter++;

			if (predictedPosition.distance(onde.getPos()) <
				onde.distanceParcourue(bot.getTime())+(counter+1)*onde.vitesse) {
				intercepted = true;
			}
		} while(!intercepted && counter < 500);
//		System.out.println(predictedPosition.x+" "+predictedPosition.y);

		return predictedPosition;
	}

	public double wallSmoothing(Point2D.Double pos, double angle, int orientation) {
		while (!terrain.contains(projecte(pos,angle,180))) {
			angle+=orientation*0.05;
		}
		return angle;
	}

	public static Point2D.Double projecte(Point2D.Double sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.x+Math.sin(angle)*length,
			sourceLocation.y+Math.cos(angle)*length);
	}

	public static double limite(double min, double a, double max) {
		return Math.max(min,Math.min(a,max));
	}


	double maxEscapeAngle(double puissance){
		return Math.asin(8./Rules.getBulletSpeed(puissance));
	}

	int angle2bin(double angle,double puissance){
		double escape=maxEscapeAngle(puissance);
		double gf=angle/escape;
		int bin=(int)((gf+1.)/2.*(nbBins-1));
		return Math.max(0,Math.min(nbBins-1,bin));
	}

	double bin2angle(int bin,double puissance){
		double escape=maxEscapeAngle(puissance);
		return (((double)bin*2)/(nbBins-1)-1)*escape;
	}

	public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
		return Math.atan2(target.x - source.x, target.y - source.y);
	}

	public void onPaint(java.awt.Graphics2D g) {
		if (!gfs.containsKey(ancCible)) return;
		double bins[][]=(double[][])gfs.get(ancCible);
		for (int i=0;i<ondes.size();i++){
			SonOnde onde=(SonOnde)ondes.get(i);
			int segment=onde.getSegment();
			double nb=(Double)nbAmeliore[segment].get(ancCible);
			for (int index=0;index<nbBins-1;index++){
				double a1=bin2angle(index,onde.getEnergie());
				double a2=bin2angle(index+1,onde.getEnergie());
				int dist=(int)onde.distanceParcourue(bot.getTime());
				double add=absoluteBearing(onde.getPos(),onde.getAncPos());
				Point2D.Double p1=projecte(onde.getPos(),a1+add,dist);
				Point2D.Double p2=projecte(onde.getPos(),a2+add,dist);
				g.setColor(new java.awt.Color((int)(bins[segment][index]*255./nb),0,0));
				g.drawLine((int)p1.x,(int)p1.y,(int)p2.x,(int)p2.y);
			}
		}
		int segment=0;
		double nb=(Double)nbAmeliore[segment].get(ancCible);
		g.setColor(java.awt.Color.blue);
		for (int i=1;i<nbBins;i++){
			int x1=(int)(200./nbBins*(i-1)),x2=(int)(200./nbBins*i);
			int y1=(int)(400.*bins[segment][i-1]/nb),y2=(int)(400.*bins[segment][i]/nb);
			g.drawLine(x1,y1,x2,y2);
		}
		segment=1;
		nb=(Double)nbAmeliore[segment].get(ancCible);
		g.setColor(java.awt.Color.blue.darker());
		for (int i=1;i<nbBins;i++){
			int x1=(int)(200./nbBins*(i-1)),x2=(int)(200./nbBins*i);
			int y1=(int)(400.*bins[segment][i-1]/nb),y2=(int)(400.*bins[segment][i]/nb);
			g.drawLine(x1,y1,x2,y2);
		}
	}
}
