package kawigi.sbf.core;
import robocode.*;
import kawigi.sbf.utils.*;
import kawigi.sbf.core.messages.*;
import java.io.*;

/**
 * TeamController - general team strategy implementation.
 */
public class TeamController
{
	public static void doTeamMovement(TeamRobot r)
	{
		if (Utils.countEnemies() == 0)
			TeamMovement.victoryDance(r);
		else
		{
			TeamMovement.minimumRiskMovement(r, TeamMovement.MORONI);
		}
	}
	
	public static void receiveMessage(Object message)
	{
		if (message instanceof AllyUpdateMessage)
		{
			AllyUpdateMessage update = (AllyUpdateMessage)message;
			VolatileEnemy ally = Utils.getTeammate(update.getName());
			if (ally != null)
			{
				ally.currentTarget = Utils.getEnemy(update.getTarget());
				ally.setLocation(update.getLocation());
				ally.teammate = true;
				ally.leader = update.isLeader();
				ally.droid = update.isDroid();
				//ally.assassin = update.isAssassin();
			}
		}
		else if (message instanceof EnemyUpdateMessage)
		{
			EnemyUpdateMessage update = (EnemyUpdateMessage)message;
			VolatileEnemy enemy = Utils.getEnemy(update.getName());
			enemy.update(update);
		}
		else if (message instanceof TargetChangeMessage)
		{
			TargetChangeMessage change = (TargetChangeMessage)message;
			VolatileEnemy enemy = Utils.getEnemy(change.getTargeterName());
			enemy.currentTarget = Utils.getTeammate(change.getTargetName());
		}
		else if (message instanceof WaveHitMessage)
		{
			WaveHitMessage hit = (WaveHitMessage)message;
			Stats stats = Utils.getStats(Utils.getRealName(hit.getName()));
			int[] segment = stats.getSegment(hit.getIndexes());
			segment[(int)Math.round(Math.min(0, Math.max(2, hit.getGuessFactor()+1))*(segment.length-1))]++;
		}
	}
	
	public static void sendMessage(Serializable message)
	{
		if (Utils.isTeamGame())
		{
			try
			{
				Utils.getRobot().broadcastMessage(message);
			}
			catch (IOException ex)
			{
				System.out.println("Error - couldn't send message: " + ex);
			}
		}
	}
}
