package kawigi.sbf.core;
import robocode.*;
import java.awt.geom.*;
import java.util.*;
import kawigi.sbf.utils.*;

/**
 * TeamMovement - center for Team-based movement concepts.
 */
public class TeamMovement
{
	private static Point2D next, last;
	
	// Risk Function types:
	
	// Survivalist don't-target-me movement (like melee movement for team):
	public static final int CORIANTUMR = 1;
	// Assassination-based movement:
	public static final int TEANCUM = 2;
	// Normal leader movement:
	public static final int MORONI = 3;
	
	public static void init()
	{
		next = null;
		last = null;
	}
	
	//What kind of good team doesn't have a synchronized, choreographed victory dance?
	public static void victoryDance(TeamRobot r)
	{
		r.setAhead(100*Math.sin(r.getTime()/5.0));
		r.setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(Math.atan2(r.getBattleFieldWidth()/2-r.getX(), r.getBattleFieldHeight()/2-r.getY())-r.getGunHeadingRadians()));
		r.setTurnRightRadians(robocode.util.Utils.normalRelativeAngle(Math.toRadians(r.getTime()*5)-r.getHeadingRadians()));
		r.setFire(0);
	}
	
	public static void goToNext(TeamRobot r)
	{
		Point2D myLocation = Utils.getMyLocation();
		double distance = next.distance(myLocation);
		double turn = Utils.angle(next, myLocation)-r.getHeadingRadians();
		if (Math.cos(turn) < 0)
		{
			turn += Math.PI;
			distance = -distance;
		}
		r.setTurnRightRadians(Utils.normalize(turn));
		//avoid running into walls when I'm turning.
		if (!Utils.inField(Utils.projectPoint(myLocation, r.getHeadingRadians(), Math.max(-20, Math.min(20, distance)))))
			distance = 0;
		r.setAhead((Math.abs(r.getTurnRemainingRadians()) > 1) ? 0 : distance);
	}
	
	//Search for enemy:
	public static void wanderPoint(TeamRobot robot)
	{
		if (next.distance(Utils.getMyLocation()) < 20)
			next = new Point2D.Double(50 + Math.random()*(Utils.fieldWidth-100), 50 + Math.random()*(Utils.fieldHeight-100));
		goToNext(robot);
	}
	
	//Generic minimum-risk movement:
	public static void minimumRiskMovement(TeamRobot r, int type)
	{
		Point2D myLocation = Utils.getMyLocation();
		VolatileEnemy currentTarget = Utils.getCurrentTarget();
		if (currentTarget != null)
		{
			if (last == null)
				last = new Point2D.Double(myLocation.getX(), myLocation.getY());
			if (next == null)
				next = last;
			boolean changed = false;
			double distance = Math.min(300, myLocation.distance(currentTarget)/2);
			//sometimes I'll change my point here, sometimes I won't.  It's a big mystery!
			for (double angle = 0; angle < Math.PI*2; angle += .1)
			{
				Point2D p = Utils.projectPoint(myLocation, angle, distance);
				if (Utils.inFieldTrunc(p) && findRisk(p, r, type) < findRisk(next, r, type))
				{
					changed = true;
					next = p;
				}
			}
			//this helps the whole movement system know what direction I'm going, and avoid head-on targeting:
			if (changed)
				last = myLocation;
			goToNext(r);
		}
	}
	
	//Risk function that routes to other risk functions
	public static double findRisk(Point2D next, TeamRobot r, int type)
	{
		switch (type)
		{
			case CORIANTUMR:
				return coriantumrRisk(next, r);
			case TEANCUM:
				return teancumRisk(next, r);
			case MORONI:
				return moroniRisk(next, r);
			default:
				return 0;
		}
	}
	
	private static double coriantumrRisk(Point2D next, TeamRobot r)
	{
		return 0;
	}
	
	private static double teancumRisk(Point2D next, TeamRobot r)
	{
		return 0;
	}
	
	// The default leader movement - tends to seek out the enemy leader but is
	// overall conservative - you don't want your leader to die!
	private static double moroniRisk(Point2D point, TeamRobot robot)
	{
		Point2D myLocation = Utils.getMyLocation();
		VolatileEnemy me = Utils.getTeammate(Utils.getRobot().getName());
		double risk = 0;
		Iterator it = Utils.getEnemies();
		Line2D travelLine = new Line2D.Double(myLocation, point);
		while (it.hasNext())
		{
			VolatileEnemy e = (VolatileEnemy)it.next();
			//start with an anti-gravity-type value:
			double thisrisk = Math.max(robot.getEnergy(), e.energy)/point.distanceSq(e);
			//int closer = 0;
			//Iterator it2 = getEnemyIterator();
			//do
			//{
			//	EnemyInfo e2 = (EnemyInfo)it2.next();
			//	if (e.distance(e2)*.9 > e.distance(point))
			//		closer++;
			//}
			//while (it2.hasNext());
			//try this, multiply this number by the number of enemies to which I would be the closest:
			//if they are likely targeting me, multiply by some factor that has to do with "perpendicularity"
			//(I think I remember David Alves calling it that):
			//if (closer <= 1 || e.targetingMe || e == currentTarget)
			thisrisk *= (e.leader ? -1 : 1) * (1+targetingMeOdds(me, e)) + (2*targetingMeOdds(me, e))*Math.abs(Math.cos(Utils.angle(myLocation, point) - Utils.angle(e, myLocation)));
			//	thisrisk *= (e.leader ? -2 : 2)+2*Math.abs(Math.cos(Utils.angle(myLocation, point) - Utils.angle(e, myLocation)));
			//stay out of the line of fire!
			if (e.currentTarget != null)
			{
				Line2D lineToTarget = new Line2D.Double(e, e.currentTarget);
				thisrisk *= 1+(lineToTarget.intersectsLine(travelLine) ? 1 : Math.min(1, 10/lineToTarget.ptLineDistSq(point)));
			}
			//don't run into people!  (This is a guess of whether someone is between me and p)
			//I suppose this deserves an explanation.  I'm figuring that if to 36x36 squares will hit each other moving
			//along a certain vector (my vector, and I assume they'll be in roughly the same place), then a line
			//representing the vector will intersect a 72x72 square centered in the same place.
			if (travelLine.intersects(new Rectangle2D.Double(e.x-36, e.y-36, 72, 72)))
				thisrisk *= 5;
			risk += thisrisk;
		}
		it = Utils.getTeammates();
		while (it.hasNext())
		{
			VolatileEnemy e = (VolatileEnemy)it.next();
			if (e == me)
				continue;
			//start with an anti-gravity-type value:
			double thisrisk = 200/point.distanceSq(e);
			//stay out of the line of fire!
			if (e.currentTarget != null)
			{
				Line2D lineToTarget = new Line2D.Double(e, e.currentTarget);
				thisrisk *= 1+(lineToTarget.intersectsLine(travelLine) ? 1 : Math.min(1, 10/lineToTarget.ptLineDistSq(point)));
			}
			//especially don't run into my own teammates:
			if (travelLine.intersects(new Rectangle2D.Double(e.x-36, e.y-36, 72, 72)))
				thisrisk *= 100;
			risk += thisrisk;
		}
		//add a small antigravity value to the point I was at before now, just to kind of push me in straight
		//lines (this made me too hitable in one-on-one, though):
		risk += 4/last.distanceSq(point);
		//and repel my current location, to make it more likely that I change my mind before I get to my assigned
		//point (and less likely to change my mind right away maybe):
		risk += .1/myLocation.distanceSq(point);
		return risk;
	}
	
	public static double targetingMeOdds(VolatileEnemy me, VolatileEnemy enemy)
	{
		if (enemy.teammate)
			return 0;
		if (enemy.currentTarget != null && enemy.currentTarget == me)
			return 1;
		int closer = 0;
		for (Iterator it = Utils.getEnemies(); it.hasNext();)
		{
			VolatileEnemy e2 = (VolatileEnemy)it.next();
			if (enemy != e2 && enemy.distance(e2)*.9 < enemy.distance(me))
				closer++;
		}
		if (closer <= 0 || Utils.getRobot().getTime()-enemy.lastHitTime < 200)
			return 1;
		else
			return 0;
	}
}
