package cjm.chalk;

import robocode.*;

import java.util.*;

public class FlatLogGun extends BaseGun {
	
	static final double BAND_WIDTH = 6.0d;
	private int _maxScans;
	private int _topScans;
	private double _nonShotWeight;
	
	Scan[] _scans;	
	int _scanIndex;
	
	java.awt.geom.Rectangle2D.Double _walls;	
	
	
	public FlatLogGun(int maxScans, int topScans, double nonShotWeight, AdvancedRobot robot){
		_maxScans = maxScans;
		_topScans = topScans;
		_nonShotWeight = nonShotWeight;
		_scans = new Scan[_maxScans];		
		_walls = new java.awt.geom.Rectangle2D.Double(10d, 10d, robot.getBattleFieldWidth() - 20d, robot.getBattleFieldHeight() - 20d);
	}
	
	public void addScan(Scan s){
		_scans[_scanIndex % _maxScans] = s;
	    _scanIndex++;	   
	}	
	
	public double projectBearing(Scan scan, double x, double y, double enemyHeading){
		
		double distance = scan.Distance;
		
		double err = 0;
		double theBearing, projectedX, projectedY, projectedDistance;;
	    Scan[] bestNodes = new Scan[_topScans];
	    double[] bestErrs = new double[_topScans];
	    Arrays.fill(bestErrs, Double.MAX_VALUE);
		int results = 0;
		
		double d, vc, lv, av, wt, wb, a;
		
		for(int i = Math.min(_scans.length, _scanIndex); --i >= 0;){		
		    
		    Scan s = _scans[i];   
		    
		    err = ((d = (scan.NormalizedDistance - s.NormalizedDistance)) * d) +
		    	((vc = (scan.SinceVelocityChange - s.SinceVelocityChange)) * vc) +
		    	((lv = (scan.LateralVelocity - s.LateralVelocity)) * lv) +
		    	((av = (scan.AdvancingVelocity - s.AdvancingVelocity)) * av) +
		    	((wt = (scan.WallTriesForward - s.WallTriesForward)) * wt) +
		    	((wb = (scan.WallTriesBack - s.WallTriesBack)) * wb) +
		    	((a = (scan.Acceleration - s.Acceleration)) * a); 

		    int j = _topScans - 1;
		    if(err < bestErrs[j]){
			    while(--j >= 0 && err < bestErrs[j]){
		            bestErrs[j + 1] = bestErrs[j];
		            bestNodes[j + 1] = bestNodes[j];
			    }
			    bestErrs[++j] = err;	
			    bestNodes[j] = s;
		    }
			        
		    results++;
		   
		}
		
		results = Math.min(results, _topScans);
		    
		if(results > 0){	
		
			//remove out-of-bounds scans			
//			int index = 0;
//			for(int i = 0; i < results; i++){
//				theBearing = (bestNodes[i].BearingRadians * scan.MaxAngle) / bestNodes[i].MaxAngle;
//				projectedDistance = distance + bestNodes[i].DistanceDelta;
//				projectedX = x + Math.sin(enemyHeading + theBearing) * projectedDistance;
//				projectedY = y + Math.cos(enemyHeading + theBearing) * projectedDistance;
//				if(_walls.contains(projectedX, projectedY)){
//					if(i != index){
//						bestNodes[index] = bestNodes[i];
//					}
//					index++;
//				}
//			}
//			
//			results = index;
			
//			if(results > 0){
				
			//calculate density on observed bearings
			int bestIndex = 0;
			double bestDensity = 0;
			
			for(int i = results; --i >= 0;){
				
				double density = 0;
				double u;
				for(int j = results; --j >= 0;){
					density += Math.exp(
								(
									u = (bestNodes[i].Bearing - bestNodes[j].Bearing) / BAND_WIDTH
								) 
								* u 
								* -0.5d
							)
							* (bestNodes[j].IsRealBullet ? 1d : _nonShotWeight);
				}
				
				density *= (bestNodes[i].IsRealBullet ? 1d : _nonShotWeight);
				
				if(density > bestDensity){
					bestDensity = density;
					bestIndex = i;
				}
			}				
				
			theBearing = (bestNodes[bestIndex].BearingRadians * scan.MaxAngle) / bestNodes[bestIndex].MaxAngle;
			projectedDistance = distance + bestNodes[bestIndex].DistanceDelta;
			projectedX = x + Math.sin(enemyHeading + theBearing) * projectedDistance;
			projectedY = y + Math.cos(enemyHeading + theBearing) * projectedDistance;
			if(_walls.contains(projectedX, projectedY)){
				return theBearing;
			}
		
		}
		return Double.MAX_VALUE;
	}	
}
