package hirataatsushi;
import robocode.*;
import java.util.*;
import java.awt.geom.*;

/**
 * TargetManager - a class by A.Hirat
 */
public class TargetManager
{
	
	
	private static TargetManager singleton = new TargetManager();
	//RXgN^B
	private TargetManager(){
		System.out.println("TargetManager : Singleton instance created...");
		targets = new Hashtable();	//WIXgAbv
		target = new Enemy();		//݂̕WI킷NX
									//̃CX^X𐶐
	}
	//^[Qbg}l[W[̃CX^XԂB
	public static TargetManager getInstance(){
		return singleton;
	}
	
	//SĂ̓Gĩf[^jnbVe[uɊi[܂B
	private Hashtable		targets;		
	//݂̕WII	
	private Enemy			target;
	//@{bgւ̎Q
	private AdvancedRobot	mybot;	

	//قǒeĂG
	Enemy			prevShooterBot = null;
	
	//قǏՓ˂G
	Enemy			prevRammerBot = null;
	
	//@tB[h̒Sɂ邩ǂ
	private boolean			atCenter = false;
	//ANZbT
	public boolean isAtCenter(){
		if (mybot.getX() == mybot.getBattleFieldWidth()/2 &&
		    mybot.getY() == mybot.getBattleFieldHeight()/2) {
			return true;
		} else {
			return false;
		}
	}
	
	//The number of consecutive bullet hits by prevShooterBot.
	int				attackerShotCount = 0;
	
	//The number of consecutive ramming attacks by prevRammerBot.
	int				attackerRamCount = 0;
	//Ōɒe
	long 			prevShotTime = 0;
	//ŌɏՓ˂ꂽ
	long			prevRamTime = 0;
	
		
	
	//@ւ̎QƂZbg	
	public void setMyBot(AdvancedRobot bot){
		mybot = bot;
	}
	
	//VWIłΒ~
	public void setTarget(ScannedRobotEvent e){
		Enemy en;
		if (targets.containsKey(e.getName())) {
			en = (Enemy)targets.get(e.getName());
		} else {
			en = new Enemy();
			targets.put(e.getName(),en);
		}
		//G{bĝpΊpœ
		double absbearing_rad = (mybot.getHeadingRadians()+e.getBearingRadians())%(2*Math.PI);
		//^[QbgɊւSĂ̏Zbg
		en.setName( e.getName() );
		double h = Helper.normalizeBearingRadians(e.getHeadingRadians() - en.getHeading());
		h = h/(mybot.getTime() - en.getCTime());
		en.setChangeHead( h );
		Point2D.Double pos = new Point2D.Double();	
		pos.setLocation(mybot.getX()+Math.sin(absbearing_rad)*e.getDistance(),
						mybot.getY()+Math.cos(absbearing_rad)*e.getDistance());
		en.setPosition( pos );
		en.setBearing( e.getBearingRadians() );
		en.setHeading( e.getHeadingRadians() );
		en.setCTime( mybot.getTime() );				//̃XLsꂽQ[
		en.setSpeed( e.getVelocity() );
		en.setDistance( e.getDistance() );	
		en.setLive( true );
		en.setEnergy( e.getEnergy() );	
		
		evadeBullet(en);

	}
	
	private void evadeBullet(Enemy target){
		//----------------------------
		double points = 0;
		
		if (CurrentBotMode.currMode == BotMode.EVADE_FIRE &&
			target.getName() == prevShooterBot.getName() ){
				points = prevShooterBot.getEnergy() - target.getEnergy();
				System.out.print("points is ");
				System.out.println(points);
				//prevShooterBot = target;
		}
		
		if (points >= Constants.MIN_BULLET_POWER &&
		    points <= Constants.MAX_BULLET_POWER ) {
			VehicleSystem v = VehicleSystem.getInstance();
			System.out.println("TargetManager ==> change mode to EVADE_FIRE");
			v.evadeFireMove(prevShooterBot);
			CurrentBotMode.currMode = BotMode.EVADE_FIRE;
			//mybot.execute();
		}
	}
	
	public Enemy getTarget(String Name){
		return (Enemy)targets.get(Name);
	}
	
	public boolean isTargetExists(){
		if (targets.size() > 0){
			return true;
		} else {
			return false;
		}
	}
	
	public void deleteTarget(String dt){
		targets.remove(dt);
	}

	public Iterator getIterator(){
		return targets.values().iterator();
	}
	
	
	public Enemy getNearestTarget(){
		double distance = Double.POSITIVE_INFINITY;
		Iterator iterator = targets.values().iterator();
		Enemy current = new Enemy();
		while(iterator.hasNext()){
			Enemy tmp = (Enemy)iterator.next();
			if ( tmp != null ){
				if ( distance > tmp.getDistance() ) {
					distance = tmp.getDistance();
					current = tmp;
				} 
			}
		}
		return current;
	}
}
