package ags.polylunar.communication;

import java.io.Serializable;
import ags.util.points.*;
import ags.polylunar.robotdata.SelfStatus;

public class BeconData implements Serializable {
    private static final long serialVersionUID = 1L;
    public final AbsolutePoint location;
    public final RelativePoint velocity;
    public final double energy;
    public final double radarHeading;
    public BeconData(SelfStatus s) {
        location = s.getLocation();
        velocity = s.getVelocity();
        energy = s.status.getEnergy();
        radarHeading = s.status.getRadarHeadingRadians();
    }
}
