package dam.util;

import java.io.*;
/**
 * TargetInfo.java
 * A class that keeps the essential information about a target
 * 
 * @author David Mold
 *
 * Jun 27, 2002
 */
public class TargetInfo implements Serializable
{
	public int time = 0;
	public double headingChange = 0;
	public double velocity = 0;
	
	/**
	 * Method TargetInfo.
	 * @param headingChange
	 * @param velocity
	 * @param time
	 */
	public TargetInfo( double headingChange, double velocity, int time)
	{
		this.headingChange = headingChange;
		this.velocity = velocity;
		this.time = time;
	}
		
	/**
	* Measure this similarity between this and the other's
	* heading change and velocity. This can be used to detect
	* a relative pattern in a bot's movements, and to predict
	* his position at any time in the future based on them
	*/
	public double getRelativeSimilarity(TargetInfo t)
	{
		double dh = Math.abs(headingChange - t.headingChange);
		double dv = Math.abs(velocity - t.velocity);
		return dh + dv;
	}
	
}
