package davidalves.net.math;

//Imports for all classes
import robocode.*;
import davidalves.net.*;
import davidalves.net.targeting.*;
import davidalves.net.movement.*;
import davidalves.net.util.*;
import java.util.*;
import java.awt.Color;
import java.io.*;


/*
 * 
 * A moving average of infinite size, probably useless vs. enemies because it destroys the "adaptive" 
 * capability of a normal moving average, because the larger the average is, the smaller
 * the effect of new data. Good for statistics though, like overall hit %.
 * 
 */
public class InfiniteMovingAverage implements MovingAverageInterface, Serializable {//{{{
	double numerator = 0;
	double denominator = 0;
	
	public InfiniteMovingAverage(){
	
	}
	
	public double getAverage(){
		if (denominator != 0)
			return numerator / denominator;
		return 0;
	}
	
	public void addValue(double newValue){
		numerator += newValue;
		denominator += 1;
	}
	
	public void addWeightedValue(double newValue, double weight){
		numerator += newValue * weight;
		denominator += weight;
	}
	
	public double getSize(){
		return denominator;
	}
	
	public void clear(){
		numerator = 0;
		denominator = 0;	
	}
	
	public String toString(){
		return DaveString.formatDouble(getAverage()) + " [" + Math.round(denominator) + " samples]";
	}	
}