package davidalves.net.targeting.strategies;

//Imports for all classes
import robocode.*;
import davidalves.net.*;
import davidalves.net.data.*;
import davidalves.net.targeting.TargetingStrategyInterface;
import davidalves.net.util.*;
import java.util.*;
import java.awt.Color;
import java.io.*;

/**
 * @author David Alves
 *
 */
public class StatisticalLinearStrategy implements TargetingStrategyInterface, Serializable {
	double antiDodgeFactor;
	//Environment environment;
	//AbstractAdvancedBot me;
	
	public StatisticalLinearStrategy(double antiDodge){
		antiDodgeFactor = antiDodge;
	}
	
	public Point predictedIntercept(AbstractAdvancedBot me, EnvironmentInterface environment, double bulletPower){		
		RobocodeRobot target = environment.getTarget();
		Point targetLocation = target.getLocation();

		double speed = 20 - 3 * bulletPower;
		double interceptTime = targetLocation.distanceTo(me.getLocation()) / speed;
		double adjustedAntiDodge = antiDodgeFactor;


		Point intercept;
		
		if(target.getSpeed() < 0){
			adjustedAntiDodge = - antiDodgeFactor;
		}	
		
		if (adjustedAntiDodge > 0 ) {
			double x = target.maxForwardPosition(interceptTime).getX() * adjustedAntiDodge + targetLocation.getX() * (1 - adjustedAntiDodge);
			double y = target.maxForwardPosition(interceptTime).getY() * adjustedAntiDodge + targetLocation.getY() * (1 - adjustedAntiDodge);
			intercept = new Point(x,y);
		} else {
			double x = target.maxBackwardPosition(interceptTime).getX() * Math.abs(adjustedAntiDodge) + targetLocation.getX() * (1 - Math.abs(adjustedAntiDodge));
			double y = target.maxBackwardPosition(interceptTime).getY() * Math.abs(adjustedAntiDodge) + targetLocation.getY() * (1 - Math.abs(adjustedAntiDodge));
			intercept = new Point(x,y);
		}
		//me.out.println("Linear Statistics for intercept time " + interceptTime + ", speed " + target.getSpeed() + "\n   Min: " + target.maxBackwardPosition(interceptTime) + "\n   Cur: " + targetLocation + "\n   Max: " + target.maxForwardPosition(interceptTime));
		//me.out.println(DaveMath.maxBackwardDrivingDistance(0, 100));
		return intercept.nearestPossibleRobotLocation(environment.getArenaSize());
	}
	
	public String toString(){
		return "LINEAR[" + Math.rint(10 * antiDodgeFactor) / 10 + "]";
	}
}
