package ahr.ice;
import robocode.*;
import robocode.util.Utils;
import robocode.annotation.SafeStatic;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import java.math.*;
import ahr.ice.Pilot.*;
import ahr.ice.Gunner.*;
import ahr.ice.Math.*;
import ahr.ice.*;
import java.awt.Graphics2D;

/**
 * AHRBot - an abstract robot for all AHRBots
 */
public abstract class AHRBot extends AdvancedRobot
{
	public static RobotState			me,
					 					target;
	public static Vector				guns, 
										virtualBullets 		=	 new Vector();
	public 		  GFTWave				wave; 
	public static Rectangle2D.Double 	battlefield;
	public static int 					lastTargetNumber 	=	 1,
										bestGun;
	public static java.util.Hashtable 			targets 			=	 new java.util.Hashtable(); 
	public final double					PI 					=	 Math.PI, 
										infinit 			=	 Double.POSITIVE_INFINITY,
										radarLockFactor		=	 2;
	static String 						lastEnemyName; 
	static double 						lastEnemyVelocity,
				  						lateralDirection,
				 						firepower;
	public long							mrTime,
										mrTimeToNextSpot,
										timeSinceLastHRE 	=	 5000,
										timeSinceScan		=	 0;
										
	static int[]						stats 				= 	 new int[31];
	public Point2D.Double				origin 				= 	 new Point2D.Double(0,0),
										middle,
										lastCoords 			=	 origin,
										averagePosition 	=	 origin; 
	Color 								body 				=	 new Color(100,224,255),
		  								gun 				=	 new Color(0,134,255),
		  								radar 				=	 new Color(200,220,255),
		  								bullet				=	 new Color(0,143,255);
	public PointEvaluator				PE 					= 	 new PointEvaluator(this);
	int 								wallHits 			=	 0,
										robotHits 			=	 0,
										bulletMisses 		=	 0;
	public double						deltaBearing;
	public static Point2D 	location 			= new Point2D.Double(),
    						oldLocation 		= new Point2D.Double(),
 							enemyLocation 		= new Point2D.Double(),
 							oldEnemyLocation 	= new Point2D.Double();
	public Movement 					movement;							
	public abstract void run();
	public abstract void onScannedRobot	(ScannedRobotEvent e);
	public abstract void onStartUp		(					);
	public abstract void onCustomEvent	(	CustomEvent e	);
	public abstract void onRoundEnded	( RoundEndedEvent e );
	public abstract void onRobotDeath	( RobotDeathEvent e ); 
	
	public void adjust(){	
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
	}
	
	public Rectangle2D.Double getBattleField() {
		return new Rectangle2D.Double(0,0,getBattleFieldWidth(), getBattleFieldHeight());
	}

	public Point2D.Double getMiddle() {
		return new Point2D.Double(getBattleFieldWidth()/2,getBattleFieldHeight()/2);
	}
	public void onWin(WinEvent e){
	    while (true) {
		  setTurnRadarRight(360);
		  setTurnGunLeft(360);
		  setTurnRight(360);
		  setMaxVelocity(2);
		  setAhead(10);
		  execute();
	   }				
	}		
	public void setColors(){
		setBodyColor(body);
		setRadarColor(radar);
		setBulletColor(bullet);
		setScanColor(bullet);
		setGunColor(gun);
	}
	int hitMoveD=1;
	public void onHitRobot(HitRobotEvent e){
		Enemy en = setupEnemy(e.getName());
		if(!e.isMyFault()){
			en.danger+=50;
		}	
/*		setTurnRightRadians(getHeadingRadians() + e.getBearingRadians() - Math.PI/4);
		setBack(100*hitMoveD);
		hitMoveD=hitMoveD*-1;
		robotHits++;
		timeSinceLastHRE = e.getTime();
		execute(); */
	}

	public void onHitByBullet(HitByBulletEvent e){
		Enemy en = setupEnemy(e.getName());
		en.hasMovedEver=true;
		en.danger+=10;
	}
	public void onBulletMissed(BulletMissedEvent e){bulletMisses++;}
	public void onHitWall(HitWallEvent e){wallHits++;}

	public void onBulletHit(BulletHitEvent e){
		if(e.getEnergy()>0){
			Enemy en = setupEnemy(e.getName());
			en.danger/=2;
		}
	}
	
			
	public void doMRMovement(){		
		
	}
	public Point2D.Double position() {
		return new Point2D.Double(getX(),getY());
	}
	public static void addGuns(final AHRBot r){
		guns = new Vector();
		Gun defaultGun = new LinearGun();
		defaultGun.hits = 1;
		guns.add(defaultGun);
		guns.add(new HeadOnGun());
		guns.add(new CircularGun());
		guns.add(new InfinityGun());
		guns.add(new LinearIterativeGun());
		guns.add(new MeanCircularGun());
		guns.add(new MeanIterativeGun());
		guns.add(new SimpleGun());
	}				
	public void doInfo(ScannedRobotEvent e, Enemy en) {	
		double eAbsBearing = getHeadingRadians() + e.getBearingRadians();
  	  	double rX = getX(), rY = getY();
   	    double eX = rX + e.getDistance()*Math.sin(eAbsBearing),
       		  eY = rY + e.getDistance()*Math.cos(eAbsBearing);
		en.name = e.getName();
		en.bearing = e.getBearingRadians();
		en.x = eX;
		en.y = eY;
		en.energy=e.getEnergy();
		Point2D.Double coordinates = new Point2D.Double(eX,eY);
		//If their coordinates are the same and they have 0 velocity, assume they are not moving
		en.coords=coordinates;
		if(e.getVelocity()>0 && !en.hasMovedEver){
			en.hasMovedEver=true;
		}
		if(en.scans==0){
			en.scans=0;
		} else {
			en.scans++;
		}
		if(en.meanHeadingChange==0){
			for(int i = 0;i<50;i++){
				en.headings[i] = e.getHeadingRadians();
				en.velocities[i] = e.getVelocity();
			}
		} else {
			en.headings[en.scans%50] = e.getHeadingRadians();
			en.velocities[en.scans%50] = e.getVelocity();
		}
		double meanHeadingChange = 0;
		double meanVelocity = 0;
		for(int i = 0;i<50;i++){
			meanHeadingChange += i!=49 ? en.headings[i] - en.headings[i+1] : 0;
			meanVelocity += en.velocities[i];
		}
		meanHeadingChange = meanHeadingChange/49;
		meanVelocity = meanVelocity/50;
		en.meanHeadingChange = meanHeadingChange;
		en.meanVelocity = meanVelocity;
		if(en.coords == en.lastCoords && e.getVelocity()<=0){
			en.movedSinceLastScan = false;
		} else { en.movedSinceLastScan = true;}
		en.bearing = e.getBearingRadians();
		en.oldHeading = en.heading;
		en.heading = e.getHeadingRadians();
		en.ctime = getTime();				//game time at which this scan was produced
		en.speed = e.getVelocity();
		en.distance = e.getDistance();
		en.lastCoords = en.coords;	
		en.live = true;
		targets.remove(e.getName());
		targets.put(e.getName(),en);
	}				
	public Enemy doEInfo(ScannedRobotEvent e, Enemy en) {	
		double eAbsBearing = getHeadingRadians() + e.getBearingRadians();
  	  	double rX = getX(), rY = getY();
   	    double eX = rX + e.getDistance()*Math.sin(eAbsBearing),
       		  eY = rY + e.getDistance()*Math.cos(eAbsBearing);
		en.name = e.getName();
		en.bearing = e.getBearingRadians();
		en.x = eX;
		en.y = eY;
		en.energy=e.getEnergy();
		Point2D.Double coordinates = new Point2D.Double(eX,eY);
		//If their coordinates are the same and they have 0 velocity, assume they are not moving
		en.coords=coordinates;
		if(e.getVelocity()>0 && !en.hasMovedEver){
			en.hasMovedEver=true;
		}
		if(en.scans==0){
			en.scans=0;
		} else {
			en.scans++;
		}
		if(en.meanHeadingChange==0){
			for(int i = 0;i<50;i++){
				en.headings[i] = e.getHeadingRadians();
				en.velocities[i] = e.getVelocity();
			}
		} else {
			en.headings[en.scans%50] = e.getHeadingRadians();
			en.velocities[en.scans%50] = e.getVelocity();
		}
		double meanHeadingChange = 0;
		double meanVelocity = 0;
		for(int i = 0;i<50;i++){
			meanHeadingChange += i!=49 ? en.headings[i] - en.headings[i+1] : 0;
			meanVelocity += en.velocities[i];
		}
		meanHeadingChange = meanHeadingChange/49;
		meanVelocity = meanVelocity/50;
		en.meanHeadingChange = meanHeadingChange;
		en.meanVelocity = meanVelocity;
		if(en.coords == en.lastCoords && e.getVelocity()<=0){
			en.movedSinceLastScan = false;
		} else { en.movedSinceLastScan = true;}
		en.bearing = e.getBearingRadians();
		en.oldHeading = en.heading;
		en.heading = e.getHeadingRadians();
		en.ctime = getTime();				//game time at which this scan was produced
		en.speed = e.getVelocity();
		en.distance = e.getDistance();
		en.lastCoords = en.coords;	
		en.live = true;
		targets.remove(e.getName());
		targets.put(e.getName(),en);
		return(en);
	}
	public void turnAwayFrom(Point2D.Double p){
		double angleToPoint 	= 	math.calculateBearingToXYRadians(me.x,me.y,getHeadingRadians(),p.x,p.y);
		double angleFromPoint 	= 	angleToPoint+Math.toRadians(180);
		turnRightRadians(getHeadingRadians()-angleFromPoint);
	}
	public static Enemy setupEnemy(String name){
		Enemy e;
		if(targets.containsKey(name)){
			e = (Enemy)targets.get(name);
		}
		else {
			e = new Enemy();
			targets.put(name,e);
		}
		return e;
	}

	public RobotState setupTarget(ScannedRobotEvent e){
			RobotState t = new RobotState();
			t.setLocation(me.project(e.getBearingRadians() + getHeadingRadians(), e.getDistance()));
			t.heading = e.getHeadingRadians();
			t.velocity = e.getVelocity();
			t.name = e.getName();
			return t;
	}

	public void virtualGun(){
		VirtualGuns.moveBullets(battlefield);
		if(target != null){
			VirtualGuns.gun();
		}
	}
	
	public void goTo(double x, double y) {
	    double dist = 20; 
	    double angle = Math.toDegrees(math.absbearing(getX(),getY(),x,y));
	    double r = turnTo(angle);
	    setAhead(me.distance(new Point2D.Double(x,y)) * r);
	}
	public int turnTo(double angle) {
	    double ang;
	    	int dir;
	    ang = math.normaliseBearing(getHeading() - angle);
	   if (ang > 90) {
	        ang -= 180;
	        dir = -1;
	    }
	    else if (ang < -90) {
	        ang += 180;
	        dir = -1;
	    }
	    else {
	        dir = 1;
	    }
	    setTurnLeft(ang);
	    return dir;
	}
	public void adjustGunHits(){
		if(getRoundNum()%5==0){ 
			Iterator i = guns.iterator();
			while(i.hasNext()){
				Gun gun = (Gun) i.next();
				gun.hits/=50;
			}
		}
	}    
	public ahr.Math.Enemy bestTarget(ahr.Math.Enemy en){
		ahr.Math.Enemy targetEnemy = en;
		double bestTargetRating = 100000;
		Enumeration enu = targets.elements();
		while(enu.hasMoreElements()){
			double targetRating = 0;
			ahr.Math.Enemy enem = (ahr.Math.Enemy)enu.nextElement();
			Point2D.Double enP	=	new Point2D.Double(enem.x,enem.y);
			Enumeration i = targets.elements();
			while(i.hasMoreElements()){
				ahr.Math.Enemy j = (ahr.Math.Enemy)i.nextElement();
				Point2D.Double  jP 	= 	new Point2D.Double(j.x,j.y);
								
				targetRating+= jP.distance(enP);
			}
			targetRating += enP.distance(position());
			if(targetRating<bestTargetRating && enem.name!=null && enem.live){
				targetEnemy=enem;
				bestTargetRating = targetRating;
			}
		}
		return targetEnemy;
	}
	public void setFirepower(ScannedRobotEvent e) {
		double bestP =1.5 + ((getEnergy()/(100/3)) * (300/e.getDistance()));
		double pToKill = ((e.getEnergy()+2)/6)+0.1;
		firepower = Math.min(bestP, Math.min(getEnergy()-0.1, Math.min(3,pToKill)));
		
	}
	public RobotState myState(){
			RobotState m = new RobotState();
			m.name = "me";
			m.velocity = getVelocity();
			m.heading = getHeadingRadians();
			m.x = getX();
			m.y = getY();
			m.gunHeading= getGunHeadingRadians();
			return m;
	}

}

