package ags.utils.dataStructures.trees.thirdGenKD;

/**
 *  Superclass for subclasses that use weighted dimensions.
 *
 *     Any child classes should implement DistanceFunction and override 
 *
 *     distance() and distanceToRect().
 */
public abstract class WeightedDistanceFunction implements DistanceFunction {

	private double[] weights;
	
	// Constructor. Loads weights.
	public WeightedDistanceFunction(double[] weights) {
		setWeights(weights);
	}
	
	// Unweighted constructor, just in case the user forgets to specify weights.
	//  Loads the failover 1.0 weights from setWeights().
	public WeightedDistanceFunction() {
		setWeights(null);
	}
	
	// Loads a new set of weights.  Default is a weight of 1.0 if passed bad data.
	public void setWeights(double[] weights) {
		if ( weights == null || weights.length == 0 ) {
			this.weights = new double[1];
			this.weights[0] = 1.0;
			return;
		}
		this.weights = weights;
	}
	
	// Returns the current set of weights.
	public double[] getWeights() {
		return this.weights;
	}
	
	// Returns the weight for the index-th dimension.  
	// Out of bounds requests return a weight of one.
	public double getWeight(int index)
	{
		if ( index < 0 || index >= weights.length ) {
			return 1.0;
		}
		return weights[index];
	}
	
	// Child classes override this!
	@Override
    public abstract double distance(double[] p1, double[] p2);
	
	// Child classes override this!
    @Override
    public abstract double distanceToRect(double[] point, double[] min, double[] max);
	
}