package tjk.offense;

import robocode.*;
import robocode.util.Utils;
import tjk.deBroglie;
import tjk.universe.*;
import tjk.defense.Wheels;
import java.util.ArrayList;


/**
 * Gun - a class by tkiesel
 * Copyright (c) 2012 Tom Kiesel (Tkiesel @ Robowiki)
 * 
 * This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held liable for any damages arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose, including commercial applications, and to alter it and redistribute it freely, subject to the following restrictions:
 * 
 *     1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. 
 *        If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 * 
 *     2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 * 
 *     3. This notice may not be removed or altered from any source distribution.
 * 
 */

public class Gun
{
	
	private Universe universe;
	
	private Wheels wheels;
	
	private Bot me;
	
	private Bot enemy;
	
	private WaveStats stats;
	
	private AdvancedRobot robot;
	
	private TargetAngle target = null;
	
	private Bullet FiredBullet = null;
	
	private Wave FiredWave = null;
	
	private VirtualGunManager guns = null;
	
	private ArrayList<Wave> activeWaves = new ArrayList<Wave>(5);
	
	public Gun(AdvancedRobot r, Universe u, Wheels w)
	{
		robot = r;
		universe = u;
		wheels = w;
		me = universe.getMe();
		enemy = universe.getEnemy();
		stats = me.getStats();
		guns = new VirtualGunManager(universe, stats);
	}	
	
	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot() {
	    
		// Check for fired bullet last tick.
		if ( FiredBullet != null && FiredWave != null )
		{
			if ( FiredBullet.isActive() )
			{
				
				FiredWave.real = true;
				activeWaves.add(FiredWave);
				guns.gunWasUsed();
				// Wave should have been fired already.
				//me.fireWave(FiredWave);
				
				// TODO: add bullet shadows with FiredBullet.
				
				FiredBullet = null; 
				FiredWave = null;
				target = null;
				return;
			}
			target = null;
		}
		
		// Check for dead active waves.  Load them to VirtualGunManager
		for ( Wave w : activeWaves)
		{
			if ( w.getState() == Wave.DEAD )
			{
				guns.loadWave(w);
				activeWaves.remove(w);
				break;
			}
		}
		
		// Choose firepower.
		double firepower = chooseFirepower();
				
		//Make Wave (virtual)
		Wave thisWave = me.getWave(false,firepower,Universe.getTime());
		// Shoot Virtual wave.
		me.fireWave(thisWave);
		
		// Only perform aiming with < 2 turns left till shot.
		double turnsTillShoot = robot.getGunHeat() / robot.getGunCoolingRate();
		if ( Double.compare(turnsTillShoot,2.0) > 0.0 )
		{
			target = null;
		}
		else
		{
			if ( me.getStatSize() > 5 )
			{
				target = new TargetAngle( guns.tagAndShoot(thisWave) );										
			}
			else
			{
				target = new TargetAngle( guns.circleShot(firepower) );
			}
		}
		
		// Aim at Target
		if ( target != null )
		{
			robot.setTurnGunRightRadians( Utils.normalRelativeAngle( target.angle - robot.getGunHeadingRadians() ) );
		}
		else {
			robot.setTurnGunLeftRadians( Utils.normalRelativeAngle( robot.getGunHeadingRadians() - me.headingToEnemy() ) );
		}
		
		// Shoot if ready to shoot.
		// && target.gunOnTarget(robot)
		if ( target != null && Double.compare(robot.getGunHeat(),0.0) <= 0 ) 
		{
			FiredBullet = robot.setFireBullet(firepower);
			FiredWave = thisWave;
			return;
		}
		
	}
	
	private double chooseFirepower()
	{
		double firepower = 1.95;
		
		double dist = me.getLocation().distance(enemy.getLocation());
		
		if ( dist <= 100 )
		{
			firepower = 3.0;
		}
		else if ( dist <= 150 )
		{
			firepower = 2.7;
		}
		
		firepower = Math.min( me.getEnergy()/5.0 , firepower );
		
		if ( enemy.getEnergy() <= 4 )
		{
			firepower = Math.min(enemy.getEnergy()/4.0 + 0.001, firepower);
		}
		else if  ( enemy.getEnergy() < 6.0*firepower - 2.0  )
		{
			firepower = Math.min( (enemy.getEnergy()+2.0)/6.0 + 0.001 , firepower);
		}
		
		if (deBroglie.isTC || (wheels.isRamming() && dist <= 150) )
		{
			firepower = 3.0;
		}
		
		return firepower;
	}
	
	public void onRoundEnded()
	{
		guns.onRoundEnded();
	}
	
}