package tjk.universe;

import robocode.*;
import java.awt.geom.Point2D;
import java.awt.Graphics2D;
import java.awt.Color;

/**
 * Universe - a class by tkiesel
 * Copyright (c) 2012 Tom Kiesel (Tkiesel @ Robowiki)
 * 
 * This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held liable for any damages arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose, including commercial applications, and to alter it and redistribute it freely, subject to the following restrictions:
 * 
 *     1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. 
 *        If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 * 
 *     2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 * 
 *     3. This notice may not be removed or altered from any source distribution.
 * 
 */

public class Universe
{
	
	private AdvancedRobot robot;
	
	private Bot me,enemy;
	
	private static double battleFieldWidth,battleFieldHeight,battleFieldDiag;
	
	private static long time = 0;
	
	private static int roundNum = 0;
	
	private static int numRounds = 35;
	
	public Universe(AdvancedRobot r)
	{
		robot = r;
		me = new Bot(this);
		enemy = new Bot(this);
		me.setEnemy(enemy);
		enemy.setEnemy(me);
	}
	
	public void init()
	{
		me.setHeat(robot.getGunHeat());
		enemy.setHeat(robot.getGunHeat());
		battleFieldWidth = robot.getBattleFieldWidth();
		battleFieldHeight = robot.getBattleFieldHeight();
		battleFieldDiag = Math.sqrt(Math.pow(battleFieldWidth,2) + Math.pow(battleFieldHeight,2));
		numRounds = robot.getNumRounds();
		roundNum = robot.getRoundNum();
		time = robot.getTime();
	}
	
	public void update(ScannedRobotEvent e) 
	{
		time = robot.getTime();
		roundNum = robot.getRoundNum();
		
		enemy.update(robot,e);
		me.update(robot);
		enemy.updateWaves();
		me.updateWaves();
		
		// Enemy fires waves.
		//enemy.checkFireWave();
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e)
	{
		Bullet myBullet = e.getBullet();
		Bullet theirBullet = e.getHitBullet();
		
		//TODO: remove bullet shadows.
		
		double averageX = (myBullet.getX()+theirBullet.getX())/2.0;
		double averageY = (myBullet.getY()+theirBullet.getY())/2.0;
		Point2D.Double hitLocation = new Point2D.Double(averageX,averageY);
		me.removeWave(hitLocation);
		enemy.removeWave(hitLocation);
	}
	
	public void onDeath(DeathEvent e)
	{
		clearWaves();
	}
	
	public void onWin(WinEvent e)
	{
		clearWaves();
	}
	
	public void onRoundEnded(RoundEndedEvent e)
	{
		clearWaves();
		System.out.println("My wave stat size: " + getMe().getStatSize() + " (Offense)" );
		System.out.println("Enemy wave stat size: " + getEnemy().getStatSize() + " (Defense)" );
	}
	
	private void clearWaves()
	{
		me.clearWaves();
		enemy.clearWaves();
	}
	
	public void paint(Graphics2D g)
	{
		//Painter.paintBot(g,me,new Color(0,255,0,55));
		Painter.paintBot(g,enemy,new Color(255,0,0,155));
	}
	
	public Bot getMe()
	{
		return me;
	}

	public Bot getEnemy()
	{
		return enemy;
	}
	
	public static double bfW()
	{
		return battleFieldWidth;
	}

	public static double bfH()
	{
		return battleFieldHeight;
	}
	
	public static double bfDiag()
	{
		return battleFieldDiag;
	}	
	
	public static long getTime()
	{
		return time;
	}
	
	public static int getRoundNum()
	{
		return roundNum;
	}
	
	public static int getNumRounds()
	{
		return numRounds;
	}
	
}
