package kcn.percept;

import robocode.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;

public class PerceptBot extends AdvancedRobot {
    private static final double idealDistance = 176 * 2.0;
    private static final double jukeLength = 192;
    
    public void run() {
        setAdjustRadarForGunTurn(true);
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForRobotTurn(true);
        
        setColors(Color.YELLOW, Color.YELLOW, Color.YELLOW);
        
        do {
            turnRadarRightRadians(1);
        } while(true);
    }
    
    public void onScannedRobot(ScannedRobotEvent e) {
        double absBearing = constrainAngle(getHeadingRadians() + e.getBearingRadians());
        double angleOfAdvance = (Math.PI/2) * (idealDistance / e.getDistance());
        double bulletPower = Math.min(2, Math.min(getEnergy() / 3, getBulletPower(e.getEnergy())));
        
        setTurnRightRadians(constrainAngle((getVelocity() > 0 ? -angleOfAdvance : angleOfAdvance - Math.PI) + e.getBearingRadians()));
        
        if (Math.abs(getVelocity()) == 8) {
            setAhead(maxDistance(getDistanceRemaining()));
        } else if (getVelocity() == 0 && getDistanceRemaining() == 0) {
            double forward = maxDistance((e.getDistance() / idealDistance) * jukeLength);
            double backward = maxDistance((e.getDistance() / idealDistance) * -jukeLength);
            
            if (Math.abs(forward) > Math.abs(backward)) {
                backward = 3 * forward;
            } else if (Math.abs(forward) < Math.abs(backward)) {
                forward = 3 * backward;
            }
            
            if (Math.abs(constrainAngle(absBearing - Math.PI) - e.getHeadingRadians()) < Math.PI/2) {
                // I'm in front of him
                if (e.getBearing() > 0) // he's to my right
                    setAhead(forward);
                else // he's to my left
                    setAhead(backward);
            } else {
                // I'm behind him
                if (e.getBearing() < 0) // he's to my left
                    setAhead(forward);
                else // he's to my right
                    setAhead(backward);
            }
        }

        setTurnRadarRightRadians(constrainAngle(absBearing - getRadarHeadingRadians()));
        //setTurnGunRightRadians(constrainAngle(absBearing - getGunHeadingRadians() + Math.asin(e.getVelocity()/16 * Math.sin(e.getHeadingRadians() - absBearing))));
        
        if (Math.abs(constrainAngle(absBearing + Math.PI - e.getHeadingRadians())) < Math.PI / 6 ||
            Math.abs(constrainAngle(absBearing - e.getHeadingRadians())) < Math.PI / 6) {
            setTurnGunRightRadians(circularTargeting(e, bulletPower, (((int)(Math.random() * 2) * 2) - 1) * Math.toRadians(10 - .75 * e.getVelocity()), 0, false, false));
            waitFor(new GunTurnCompleteCondition(this));
            setFire(bulletPower);
        } else if (Math.abs(e.getVelocity()) > 6 && Math.abs(e.getVelocity()) < 8) {
            double difference = constrainAngle(absBearing - e.getHeadingRadians());
            setTurnGunRightRadians(circularTargeting(e, bulletPower, 0, -sign(e.getVelocity()), false, true));
            waitFor(new GunTurnCompleteCondition(this));
            setFire(bulletPower);
        } else if (e.getVelocity() == 0 && Math.random() < 1/30.0) {
            setTurnGunRightRadians(constrainAngle(absBearing - getGunHeadingRadians()));
            waitFor(new GunTurnCompleteCondition(this));
            setFire(bulletPower);
        }
    }
    
    // Thanks to dummy for this targeting!
    // It's been modified...a lot.
    private double circularTargeting(ScannedRobotEvent e, double bulletPower, double angle, double acceleration, boolean reverse, boolean stop) {
        double absBearing = constrainAngle(getHeadingRadians() + e.getBearingRadians());
        double enemyX = e.getDistance() * Math.sin(absBearing);
        double enemyY = e.getDistance() * Math.cos(absBearing);
        double dx = Math.sin(e.getHeadingRadians());
        double dy = Math.cos(e.getHeadingRadians());
        double bulletDistance = 0;
        double velocity = e.getVelocity();
        double origVelocity = velocity, origAcceleration = acceleration;
        double bulletSpeed = 20 - 3 * bulletPower;
        int i = 0, stopTime = (int)(Math.random() * 3);
        int j = 0, jukeTime = (int)(Math.random() * 8) + 2;

        while (bulletDistance < Point2D.distance(0, 0, enemyX, enemyY)) {
            double oldX = dx;
            
            if (acceleration != 0) {
                if (j >= jukeTime) {
                    acceleration = -acceleration;
                    j = 0;
                } else {
                    j++;
                }
            }
            
            if (acceleration == 0 && velocity == 0 && stop) {
                if (i >= stopTime) {
                    if (!reverse)
                        acceleration = -origAcceleration;
                    else
                        acceleration = origAcceleration;
                    i = 0;
                } else {
                    i++;
                }
            }
            
            // move bullet forward
            bulletDistance += bulletSpeed;
            
            dx = Math.cos(angle) * oldX - Math.sin(angle) * dy;
            dy = Math.sin(angle) * oldX + Math.cos(angle) * dy;
            
            // add velocity vector
            enemyX += dx * velocity;
            enemyY += dy * velocity;
            
            // add acceleration
            if (acceleration > 0)
                velocity = Math.min(acceleration + velocity, 8.0);
            else
                velocity = Math.max(acceleration + velocity, -8.0);
            
            // reverse acceleration to continue moving forward instead of reversing
            if (sign(velocity) != sign(origVelocity) || velocity == 0) {
                if (stop) {
                    velocity = 0;
                    acceleration = 0;
                } else if (!reverse) {
                    velocity = 0;
                    acceleration = -acceleration;
                }
            }
        }

        return constrainAngle(Math.atan2(enemyX, enemyY) - getGunHeadingRadians());
    }
    
    private double getBulletPower(double damage) {
        return damage > 4 ? damage / 6 + 1/3 : damage / 4;
    }
    
    public void onHitByBullet(HitByBulletEvent event) {
        setAhead(maxDistance((-Math.abs(getVelocity())/getVelocity()) * jukeLength * 0.1));
    }
    
    private static final double constrainAngle(double angle) {
        return ((angle + (7 * Math.PI)) % (2 * Math.PI)) - Math.PI;
    }
    
    private static final double sign(double value) {
        return Math.abs(value)/value;
    }
    
    private final double maxDistance(double initial) {
        double angle = Math.PI/2 - getHeadingRadians();
        double direction = sign(initial);
        angle = constrainAngle(angle + (direction > 0 ? 0 : Math.PI));
        double x = Math.cos(angle);
        double y = Math.sin(angle);
        
        if (angle >= 0 && angle < Math.PI/2) { // top/right
            return direction * Math.min(Math.abs(initial),
             Math.min(Math.abs((getBattleFieldWidth() - getX() - 50) / x),
             Math.abs((getBattleFieldHeight() - getY() - 50) / y)));
        } else if (angle < -Math.PI/2) { // bottom/left
            return direction * Math.min(Math.abs(initial),
             Math.min(Math.abs((getX() - 50) / x), Math.abs((getY() - 50) / y)));
        } else if (angle < 0) { // bottom/right
            return direction * Math.min(Math.abs(initial),
             Math.min(Math.abs((getBattleFieldWidth() - getX() - 50) / x),
             Math.abs((getY() - 50) / y)));
        } else { // top/left
            return direction * Math.min(Math.abs(initial),
             Math.min(Math.abs((getX() - 50) / x),
             Math.abs((getBattleFieldHeight() - getY() - 50) / y)));
        }
    }
}